package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NetconfSessionEnd} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NetconfSessionEnd createNetconfSessionEnd(int fooXyzzy, int barBaz) {
 *         return new NetconfSessionEndBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NetconfSessionEnd, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NetconfSessionEnd
 *
 */
@Generated("mdsal-binding-generator")
public class NetconfSessionEndBuilder {

    private SessionIdType _killedBy;
    private SessionIdOrZeroType _sessionId;
    private IpAddress _sourceHost;
    private NetconfSessionEnd.TerminationReason _terminationReason;
    private String _username;


    Map<Class<? extends Augmentation<NetconfSessionEnd>>, Augmentation<NetconfSessionEnd>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public NetconfSessionEndBuilder() {
        // No-op
    }

    
    
    
    /**
     * Construct a new builder initialized from specified {@link CommonSessionParms}.
     *
     * @param arg CommonSessionParms from which the builder should be initialized
     */
    public NetconfSessionEndBuilder(CommonSessionParms arg) {
        this._username = arg.getUsername();
        this._sessionId = arg.getSessionId();
        this._sourceHost = arg.getSourceHost();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link NetconfSessionEnd}.
     *
     * @param base NetconfSessionEnd from which the builder should be initialized
     */
    public NetconfSessionEndBuilder(NetconfSessionEnd base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._killedBy = base.getKilledBy();
        this._sessionId = base.getSessionId();
        this._sourceHost = base.getSourceHost();
        this._terminationReason = base.getTerminationReason();
        this._username = base.getUsername();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link CommonSessionParms}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonSessionParms) {
            this._username = ((CommonSessionParms)arg).getUsername();
            this._sessionId = ((CommonSessionParms)arg).getSessionId();
            this._sourceHost = ((CommonSessionParms)arg).getSourceHost();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[CommonSessionParms]");
    }

    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionEnd#getKilledBy()}.
     *
     * @return current value
     */
    public SessionIdType getKilledBy() {
        return _killedBy;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionEnd#getSessionId()}.
     *
     * @return current value
     */
    public SessionIdOrZeroType getSessionId() {
        return _sessionId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionEnd#getSourceHost()}.
     *
     * @return current value
     */
    public IpAddress getSourceHost() {
        return _sourceHost;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionEnd#getTerminationReason()}.
     *
     * @return current value
     */
    public NetconfSessionEnd.TerminationReason getTerminationReason() {
        return _terminationReason;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionEnd#getUsername()}.
     *
     * @return current value
     */
    public String getUsername() {
        return _username;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NetconfSessionEnd>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link NetconfSessionEnd#getKilledBy()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionEndBuilder setKilledBy(final SessionIdType value) {
        this._killedBy = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfSessionEnd#getSessionId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionEndBuilder setSessionId(final SessionIdOrZeroType value) {
        this._sessionId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfSessionEnd#getSourceHost()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionEndBuilder setSourceHost(final IpAddress value) {
        this._sourceHost = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfSessionEnd#getTerminationReason()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionEndBuilder setTerminationReason(final NetconfSessionEnd.TerminationReason value) {
        this._terminationReason = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfSessionEnd#getUsername()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionEndBuilder setUsername(final String value) {
        this._username = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NetconfSessionEndBuilder addAugmentation(Augmentation<NetconfSessionEnd> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NetconfSessionEndBuilder removeAugmentation(Class<? extends Augmentation<NetconfSessionEnd>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link NetconfSessionEnd} instance.
     *
     * @return A new {@link NetconfSessionEnd} instance.
     */
    public @NonNull NetconfSessionEnd build() {
        return new NetconfSessionEndImpl(this);
    }

    private static final class NetconfSessionEndImpl
        extends AbstractAugmentable<NetconfSessionEnd>
        implements NetconfSessionEnd {
    
        private final SessionIdType _killedBy;
        private final SessionIdOrZeroType _sessionId;
        private final IpAddress _sourceHost;
        private final NetconfSessionEnd.TerminationReason _terminationReason;
        private final String _username;
    
        NetconfSessionEndImpl(NetconfSessionEndBuilder base) {
            super(base.augmentation);
            this._killedBy = base.getKilledBy();
            this._sessionId = base.getSessionId();
            this._sourceHost = base.getSourceHost();
            this._terminationReason = base.getTerminationReason();
            this._username = base.getUsername();
        }
    
        @Override
        public SessionIdType getKilledBy() {
            return _killedBy;
        }
        
        @Override
        public SessionIdOrZeroType getSessionId() {
            return _sessionId;
        }
        
        @Override
        public IpAddress getSourceHost() {
            return _sourceHost;
        }
        
        @Override
        public NetconfSessionEnd.TerminationReason getTerminationReason() {
            return _terminationReason;
        }
        
        @Override
        public String getUsername() {
            return _username;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NetconfSessionEnd.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NetconfSessionEnd.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NetconfSessionEnd.bindingToString(this);
        }
    }
}
