package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when a NETCONF server detects that a NETCONF session has started. A 
 * server MAY generate this event for non-NETCONF management sessions. Indicates 
 * the identity of the user that started the session.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-session-start {
 *   uses common-session-parms;
 * }
 * </pre>
 * <p>To create instances of this class use {@link NetconfSessionStartBuilder}.
 * @see NetconfSessionStartBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NetconfSessionStart
    extends
    DataObject,
    Notification<NetconfSessionStart>,
    Augmentable<NetconfSessionStart>,
    CommonSessionParms
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-session-start");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfSessionStart obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getSessionId());
        result = prime * result + Objects.hashCode(obj.getSourceHost());
        result = prime * result + Objects.hashCode(obj.getUsername());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfSessionStart thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionId(), other.getSessionId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSourceHost(), other.getSourceHost())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfSessionStart obj) {
        final var helper = MoreObjects.toStringHelper("NetconfSessionStart");
        CodeHelpers.appendValue(helper, "sessionId", obj.getSessionId());
        CodeHelpers.appendValue(helper, "sourceHost", obj.getSourceHost());
        CodeHelpers.appendValue(helper, "username", obj.getUsername());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

