package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NetconfSessionStart} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NetconfSessionStart createNetconfSessionStart(int fooXyzzy, int barBaz) {
 *         return new NetconfSessionStartBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NetconfSessionStart, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NetconfSessionStart
 *
 */
@Generated("mdsal-binding-generator")
public class NetconfSessionStartBuilder {

    private SessionIdOrZeroType _sessionId;
    private IpAddress _sourceHost;
    private String _username;


    Map<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public NetconfSessionStartBuilder() {
        // No-op
    }

    
    
    
    /**
     * Construct a new builder initialized from specified {@link CommonSessionParms}.
     *
     * @param arg CommonSessionParms from which the builder should be initialized
     */
    public NetconfSessionStartBuilder(CommonSessionParms arg) {
        this._username = arg.getUsername();
        this._sessionId = arg.getSessionId();
        this._sourceHost = arg.getSourceHost();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link NetconfSessionStart}.
     *
     * @param base NetconfSessionStart from which the builder should be initialized
     */
    public NetconfSessionStartBuilder(NetconfSessionStart base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._sessionId = base.getSessionId();
        this._sourceHost = base.getSourceHost();
        this._username = base.getUsername();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link CommonSessionParms}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonSessionParms) {
            this._username = ((CommonSessionParms)arg).getUsername();
            this._sessionId = ((CommonSessionParms)arg).getSessionId();
            this._sourceHost = ((CommonSessionParms)arg).getSourceHost();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[CommonSessionParms]");
    }

    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionStart#getSessionId()}.
     *
     * @return current value
     */
    public SessionIdOrZeroType getSessionId() {
        return _sessionId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionStart#getSourceHost()}.
     *
     * @return current value
     */
    public IpAddress getSourceHost() {
        return _sourceHost;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfSessionStart#getUsername()}.
     *
     * @return current value
     */
    public String getUsername() {
        return _username;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NetconfSessionStart>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link NetconfSessionStart#getSessionId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionStartBuilder setSessionId(final SessionIdOrZeroType value) {
        this._sessionId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfSessionStart#getSourceHost()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionStartBuilder setSourceHost(final IpAddress value) {
        this._sourceHost = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfSessionStart#getUsername()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfSessionStartBuilder setUsername(final String value) {
        this._username = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NetconfSessionStartBuilder addAugmentation(Augmentation<NetconfSessionStart> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NetconfSessionStartBuilder removeAugmentation(Class<? extends Augmentation<NetconfSessionStart>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link NetconfSessionStart} instance.
     *
     * @return A new {@link NetconfSessionStart} instance.
     */
    public @NonNull NetconfSessionStart build() {
        return new NetconfSessionStartImpl(this);
    }

    private static final class NetconfSessionStartImpl
        extends AbstractAugmentable<NetconfSessionStart>
        implements NetconfSessionStart {
    
        private final SessionIdOrZeroType _sessionId;
        private final IpAddress _sourceHost;
        private final String _username;
    
        NetconfSessionStartImpl(NetconfSessionStartBuilder base) {
            super(base.augmentation);
            this._sessionId = base.getSessionId();
            this._sourceHost = base.getSourceHost();
            this._username = base.getUsername();
        }
    
        @Override
        public SessionIdOrZeroType getSessionId() {
            return _sessionId;
        }
        
        @Override
        public IpAddress getSourceHost() {
            return _sourceHost;
        }
        
        @Override
        public String getUsername() {
            return _username;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NetconfSessionStart.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NetconfSessionStart.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NetconfSessionStart.bindingToString(this);
        }
    }
}
