package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditOperationType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * An edit record SHOULD be present for each distinct edit operation that the 
 * server has detected on the target datastore. This list MAY be omitted if the 
 * detailed edit operations are not known. The server MAY report entries in this 
 * list for changes not made by a NETCONF session (e.g., CLI).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * list edit {
 *   leaf target {
 *     type instance-identifier;
 *   }
 *   leaf operation {
 *     type nc:edit-operation-type;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link EditBuilder}.
 * @see EditBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface Edit
    extends
    ChildOf<NetconfConfigChange>,
    Augmentable<Edit>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edit");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.@NonNull Edit obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getOperation());
        result = prime * result + Objects.hashCode(obj.getTarget());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.@NonNull Edit thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getTarget(), other.getTarget())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOperation(), other.getOperation())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.@NonNull Edit obj) {
        final var helper = MoreObjects.toStringHelper("Edit");
        CodeHelpers.appendValue(helper, "operation", obj.getOperation());
        CodeHelpers.appendValue(helper, "target", obj.getTarget());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return target, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Topmost node associated with the configuration change. A server SHOULD set this
     *         object to the node within the datastore that is being altered. A server MAY set
     *         this object to one of the ancestors of the actual node that was changed, or omit
     *         this object, if the exact node is not known.
     *     </code>
     * </pre>
     *
     * @return {@code InstanceIdentifier<?>} target, or {@code null} if it is not present.
     *
     */
    InstanceIdentifier<?> getTarget();
    
    /**
     * Return target, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Topmost node associated with the configuration change. A server SHOULD set this
     *         object to the node within the datastore that is being altered. A server MAY set
     *         this object to one of the ancestors of the actual node that was changed, or omit
     *         this object, if the exact node is not known.
     *     </code>
     * </pre>
     *
     * @return {@code InstanceIdentifier<?>} target, guaranteed to be non-null.
     * @throws NoSuchElementException if target is not present
     *
     */
    default @NonNull InstanceIdentifier<?> requireTarget() {
        return CodeHelpers.require(getTarget(), "target");
    }
    
    /**
     * Return operation, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Type of edit operation performed. A server MUST set this object to the NETCONF
     *         edit operation performed on the target datastore.
     *     </code>
     * </pre>
     *
     * @return {@code EditOperationType} operation, or {@code null} if it is not present.
     *
     */
    EditOperationType getOperation();
    
    /**
     * Return operation, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Type of edit operation performed. A server MUST set this object to the NETCONF
     *         edit operation performed on the target datastore.
     *     </code>
     * </pre>
     *
     * @return {@code EditOperationType} operation, guaranteed to be non-null.
     * @throws NoSuchElementException if operation is not present
     *
     */
    default @NonNull EditOperationType requireOperation() {
        return CodeHelpers.require(getOperation(), "operation");
    }

}

