package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditOperationType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link Edit} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Edit createEdit(int fooXyzzy, int barBaz) {
 *         return new EditBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Edit, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Edit
 *
 */
@Generated("mdsal-binding-generator")
public class EditBuilder {

    private EditOperationType _operation;
    private InstanceIdentifier<?> _target;


    Map<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public EditBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Edit}.
     *
     * @param base Edit from which the builder should be initialized
     */
    public EditBuilder(Edit base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._operation = base.getOperation();
        this._target = base.getTarget();
    }


    /**
     * Return current value associated with the property corresponding to {@link Edit#getOperation()}.
     *
     * @return current value
     */
    public EditOperationType getOperation() {
        return _operation;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Edit#getTarget()}.
     *
     * @return current value
     */
    public InstanceIdentifier<?> getTarget() {
        return _target;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Edit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Edit#getOperation()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EditBuilder setOperation(final EditOperationType value) {
        this._operation = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Edit#getTarget()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EditBuilder setTarget(final InstanceIdentifier<?> value) {
        this._target = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EditBuilder addAugmentation(Augmentation<Edit> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EditBuilder removeAugmentation(Class<? extends Augmentation<Edit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Edit} instance.
     *
     * @return A new {@link Edit} instance.
     */
    public @NonNull Edit build() {
        return new EditImpl(this);
    }

    private static final class EditImpl
        extends AbstractAugmentable<Edit>
        implements Edit {
    
        private final EditOperationType _operation;
        private final InstanceIdentifier<?> _target;
    
        EditImpl(EditBuilder base) {
            super(base.augmentation);
            this._operation = base.getOperation();
            this._target = base.getTarget();
        }
    
        @Override
        public EditOperationType getOperation() {
            return _operation;
        }
        
        @Override
        public InstanceIdentifier<?> getTarget() {
            return _target;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Edit.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Edit.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Edit.bindingToString(this);
        }
    }
}
