package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.with.defaults.rev110601;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Contains the &lt;with-defaults&gt; parameter for control of defaults in NETCONF 
 * retrieval operations.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-with-defaults</b>
 * <pre>
 * grouping with-defaults-parameters {
 *   leaf with-defaults {
 *     type with-defaults-mode;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-with-defaultswith-defaults-parameters</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface WithDefaultsParameters
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("with-defaults-parameters");

    @Override
    Class<? extends WithDefaultsParameters> implementedInterface();
    
    /**
     * Return withDefaults, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The explicit defaults processing mode requested.
     *     </code>
     * </pre>
     *
     * @return {@code WithDefaultsMode} withDefaults, or {@code null} if it is not present.
     *
     */
    WithDefaultsMode getWithDefaults();
    
    /**
     * Return withDefaults, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The explicit defaults processing mode requested.
     *     </code>
     * </pre>
     *
     * @return {@code WithDefaultsMode} withDefaults, guaranteed to be non-null.
     * @throws NoSuchElementException if withDefaults is not present
     *
     */
    default @NonNull WithDefaultsMode requireWithDefaults() {
        return CodeHelpers.require(getWithDefaults(), "withdefaults");
    }

}

