package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains monitoring information about the YANGmodules and 
 * that are used within a YANG-basedserver.Copyright (c) 2016 IETF Trust and the 
 * persons identified asauthors of the code. All rights reserved.Redistribution 
 * use in source and binary forms, with orwithout modification, is permitted 
 * pursuant to, and subjectto the license terms contained in, the Simplified BSD 
 * Licenseset forth in Section 4.c of the IETF Trust's Legal ProvisionsRelating to 
 * IETF Documents(http://trustee.ietf.org/license-info).This version of this YANG 
 * module is part of RFC XXXX; seethe RFC itself for full legal notices.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * module ietf-yang-library {
 *     yang-version 1;
 *     namespace "urn:ietf:params:xml:ns:yang:ietf-yang-library";
 *     prefix "yanglib";
 *
 *     import ietf-inet-types { prefix "inet"; }
 *     
 *     import ietf-yang-types { prefix "yang"; }
 *     revision 2016-04-09 {
 *         description "This module contains monitoring information about the YANGmodules and 
 *                     that are used within a YANG-basedserver.Copyright (c) 2016 IETF Trust and the 
 *                     persons identified asauthors of the code. All rights reserved.Redistribution 
 *                     use in source and binary forms, with orwithout modification, is permitted 
 *                     pursuant to, and subjectto the license terms contained in, the Simplified BSD 
 *                     Licenseset forth in Section 4.c of the IETF Trust's Legal ProvisionsRelating to 
 *                     IETF Documents(http://trustee.ietf.org/license-info).This version of this YANG 
 *                     module is part of RFC XXXX; seethe RFC itself for full legal notices.
 *         ";
 *     }
 *
 *     container modules-state {
 *         leaf module-set-id {
 *             type string;
 *         }
 *         list module {
 *             key "name" "revision";
 *             leaf namespace {
 *                 type uri;
 *             }
 *             leaf-list feature {
 *                 type yang-identifier;
 *             }
 *             list deviation {
 *                 key "name" "revision";
 *                 leaf name {
 *                     type yang-identifier;
 *                 }
 *                 leaf revision {
 *                     type optional-revision;
 *                 }
 *                 uses module-list;
 *             }
 *             leaf conformance-type {
 *                 type enumeration;
 *             }
 *             container submodules {
 *                 list submodule {
 *                     key "name" "revision";
 *                     leaf schema {
 *                         type uri;
 *                     }
 *                     leaf name {
 *                         type yang-identifier;
 *                     }
 *                     leaf revision {
 *                         type optional-revision;
 *                     }
 *                     uses module-list;
 *                     uses module-list;
 *                 }
 *             }
 *             leaf schema {
 *                 type uri;
 *             }
 *             leaf name {
 *                 type yang-identifier;
 *             }
 *             leaf revision {
 *                 type optional-revision;
 *             }
 *             uses module-list;
 *             uses module-list;
 *         }
 *         grouping schema-leaf {
 *             leaf schema {
 *                 type uri;
 *             }
 *         }
 *         grouping common-leafs {
 *             leaf name {
 *                 type yang-identifier;
 *             }
 *             leaf revision {
 *                 type optional-revision;
 *             }
 *         }
 *         uses module-list;
 *     }
 *
 *     grouping module-list {
 *         grouping common-leafs {
 *             leaf name {
 *                 type yang-identifier;
 *             }
 *             leaf revision {
 *                 type optional-revision;
 *             }
 *         }
 *         grouping schema-leaf {
 *             leaf schema {
 *                 type uri;
 *             }
 *         }
 *         list module {
 *             key "name" "revision";
 *             leaf name {
 *                 type yang-identifier;
 *             }
 *             leaf revision {
 *                 type optional-revision;
 *             }
 *             leaf schema {
 *                 type uri;
 *             }
 *             leaf namespace {
 *                 type uri;
 *             }
 *             leaf-list feature {
 *                 type yang-identifier;
 *             }
 *             list deviation {
 *                 key "name" "revision";
 *                 leaf name {
 *                     type yang-identifier;
 *                 }
 *                 leaf revision {
 *                     type optional-revision;
 *                 }
 *                 uses module-list;
 *             }
 *             leaf conformance-type {
 *                 type enumeration;
 *             }
 *             container submodules {
 *                 list submodule {
 *                     key "name" "revision";
 *                     leaf name {
 *                         type yang-identifier;
 *                     }
 *                     leaf revision {
 *                         type optional-revision;
 *                     }
 *                     leaf schema {
 *                         type uri;
 *                     }
 *                     uses module-list;
 *                     uses module-list;
 *                 }
 *             }
 *             uses module-list;
 *             uses module-list;
 *         }
 *     }
 *
 *     notification yang-library-change {
 *         description
 *             "Generated when the set of modules and submodules supported
 *             by the server has changed.";
 *         leaf module-set-id {
 *             type leafref;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface IetfYangLibraryData
    extends
    DataRoot
{




    /**
     * Contains YANG module monitoring information.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.ModulesState</code> <code>modulesState</code>, or <code>null</code> if not present
     */
    ModulesState getModulesState();

}

