package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>ietf-yang-library</b>
 * <pre>
 * notification yang-library-change {
 *     description
 *         "Generated when the set of modules and submodules supported
 *         by the server has changed.";
 *     leaf module-set-id {
 *         type leafref;
 *     }
 * }
 * </pre>
 *
 */
public interface IetfYangLibraryListener
    extends
    NotificationListener
{




    /**
     * Generated when the set of modules and submodules supportedby the server has 
     * changed.
     *
     */
    void onYangLibraryChange(YangLibraryChange notification);

}

