package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module;

/**
 * The module data structure is represented as a groupingso it can be reused in 
 * configuration or another monitoringdata structure.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * grouping module-list {
 *     grouping common-leafs {
 *         leaf name {
 *             type yang-identifier;
 *         }
 *         leaf revision {
 *             type optional-revision;
 *         }
 *     }
 *     grouping schema-leaf {
 *         leaf schema {
 *             type uri;
 *         }
 *     }
 *     list module {
 *         key "name" "revision";
 *         leaf name {
 *             type yang-identifier;
 *         }
 *         leaf revision {
 *             type optional-revision;
 *         }
 *         leaf schema {
 *             type uri;
 *         }
 *         leaf namespace {
 *             type uri;
 *         }
 *         leaf-list feature {
 *             type yang-identifier;
 *         }
 *         list deviation {
 *             key "name" "revision";
 *             leaf name {
 *                 type yang-identifier;
 *             }
 *             leaf revision {
 *                 type optional-revision;
 *             }
 *             uses module-list;
 *         }
 *         leaf conformance-type {
 *             type enumeration;
 *         }
 *         container submodules {
 *             list submodule {
 *                 key "name" "revision";
 *                 leaf name {
 *                     type yang-identifier;
 *                 }
 *                 leaf revision {
 *                     type optional-revision;
 *                 }
 *                 leaf schema {
 *                     type uri;
 *                 }
 *                 uses module-list;
 *                 uses module-list;
 *             }
 *         }
 *         uses module-list;
 *         uses module-list;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/module-list</i>
 *
 */
public interface ModuleList
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "module-list").intern();

    /**
     * Each entry represents one revision of one modulecurrently supported by the 
     * server.
     *
     *
     *
     * @return <code>java.util.List</code> <code>module</code>, or <code>null</code> if not present
     */
    List<Module> getModule();

}

