package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * Contains YANG module monitoring information.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * container modules-state {
 *     leaf module-set-id {
 *         type string;
 *     }
 *     list module {
 *         key "name" "revision";
 *         leaf namespace {
 *             type uri;
 *         }
 *         leaf-list feature {
 *             type yang-identifier;
 *         }
 *         list deviation {
 *             key "name" "revision";
 *             leaf name {
 *                 type yang-identifier;
 *             }
 *             leaf revision {
 *                 type optional-revision;
 *             }
 *             uses module-list;
 *         }
 *         leaf conformance-type {
 *             type enumeration;
 *         }
 *         container submodules {
 *             list submodule {
 *                 key "name" "revision";
 *                 leaf schema {
 *                     type uri;
 *                 }
 *                 leaf name {
 *                     type yang-identifier;
 *                 }
 *                 leaf revision {
 *                     type optional-revision;
 *                 }
 *                 uses module-list;
 *                 uses module-list;
 *             }
 *         }
 *         leaf schema {
 *             type uri;
 *         }
 *         leaf name {
 *             type yang-identifier;
 *         }
 *         leaf revision {
 *             type optional-revision;
 *         }
 *         uses module-list;
 *         uses module-list;
 *     }
 *     grouping schema-leaf {
 *         leaf schema {
 *             type uri;
 *         }
 *     }
 *     grouping common-leafs {
 *         leaf name {
 *             type yang-identifier;
 *         }
 *         leaf revision {
 *             type optional-revision;
 *         }
 *     }
 *     uses module-list;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/modules-state</i>
 *
 * <p>To create instances of this class use {@link ModulesStateBuilder}.
 * @see ModulesStateBuilder
 *
 */
public interface ModulesState
    extends
    ChildOf<IetfYangLibraryData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.ModulesState>,
    ModuleList
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "modules-state").intern();

    /**
     * Contains a server-specific identifier representingthe current set of modules and
     * submodules. Theserver MUST change the value of this leaf if theinformation 
     * represented by the 'module' list instanceshas changed.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>moduleSetId</code>, or <code>null</code> if not present
     */
    java.lang.String getModuleSetId();

}

