package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import java.util.Objects;

public class OptionalRevision
 implements Serializable {
    private static final long serialVersionUID = 1876747068003269840L;
    private final RevisionIdentifier _revisionIdentifier;
    private final java.lang.String _string;
    private char[] _value;


    public OptionalRevision(RevisionIdentifier _revisionIdentifier) {
        super();
        this._revisionIdentifier = _revisionIdentifier;
        this._string = null;
    }
    
    public OptionalRevision(java.lang.String _string) {
        super();
        this._string = _string;
        this._revisionIdentifier = null;
    }
    
    /**
     * Constructor provided only for using in JMX. Don't use it for
     * construction new object of this union type.
     */
    @ConstructorProperties("value")
    public OptionalRevision(char[] _value) {
        java.lang.String defVal = new java.lang.String(_value);
        OptionalRevision defInst = OptionalRevisionBuilder.getDefaultInstance(defVal);
        this._revisionIdentifier = defInst._revisionIdentifier;
        this._string = defInst._string;
        this._value = _value == null ? null : _value.clone();
    }
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public OptionalRevision(OptionalRevision source) {
        this._revisionIdentifier = source._revisionIdentifier;
        this._string = source._string;
        this._value = source._value;
    }


    public RevisionIdentifier getRevisionIdentifier() {
        return _revisionIdentifier;
    }
    
    public java.lang.String getString() {
        return _string;
    }
    
    public char[] getValue() {
        if (_value == null) {
            if (_revisionIdentifier != null) {
                _value = _revisionIdentifier.getValue().toString().toCharArray();
            } else
            if (_string != null) {
                _value = _string.toCharArray();
            }
        }
        return _value == null ? null : _value.clone();
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_revisionIdentifier);
        result = prime * result + Objects.hashCode(_string);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        OptionalRevision other = (OptionalRevision) obj;
        if (!Objects.equals(_revisionIdentifier, other._revisionIdentifier)) {
            return false;
        }
        if (!Objects.equals(_string, other._string)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.OptionalRevision.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_revisionIdentifier != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_revisionIdentifier=");
            builder.append(_revisionIdentifier);
        }
        if (_string != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_string=");
            builder.append(_string);
        }
        return builder.append(']').toString();
    }
}

