package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * Generated when the set of modules and submodules supportedby the server has 
 * changed.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * notification yang-library-change {
 *     description
 *         "Generated when the set of modules and submodules supported
 *         by the server has changed.";
 *     leaf module-set-id {
 *         type leafref;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/yang-library-change</i>
 *
 * <p>To create instances of this class use {@link YangLibraryChangeBuilder}.
 * @see YangLibraryChangeBuilder
 *
 */
public interface YangLibraryChange
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.YangLibraryChange>,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "yang-library-change").intern();

    /**
     * Contains the module-set-id value representing theset of modules and submodules 
     * supported at the server atthe time the notification is generated.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>moduleSetId</code>, or <code>null</code> if not present
     */
    java.lang.String getModuleSetId();

}

