package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.OptionalRevision;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;

/**
 * Common parameters for YANG modules and submodules.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * grouping common-leafs {
 *     leaf name {
 *         type yang-identifier;
 *     }
 *     leaf revision {
 *         type optional-revision;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/module-list/common-leafs</i>
 *
 */
public interface CommonLeafs
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "common-leafs").intern();

    /**
     * The YANG module or submodule name.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier</code> <code>name</code>, or <code>null</code> if not present
     */
    YangIdentifier getName();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.OptionalRevision</code> <code>revision</code>, or <code>null</code> if not present
     */
    OptionalRevision getRevision();

}

