package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Submodules;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.ModuleList;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Deviation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;

/**
 * Each entry represents one revision of one modulecurrently supported by the 
 * server.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * list module {
 *     key "name" "revision";
 *     leaf name {
 *         type yang-identifier;
 *     }
 *     leaf revision {
 *         type optional-revision;
 *     }
 *     leaf schema {
 *         type uri;
 *     }
 *     leaf namespace {
 *         type uri;
 *     }
 *     leaf-list feature {
 *         type yang-identifier;
 *     }
 *     list deviation {
 *         key "name" "revision";
 *         leaf name {
 *             type yang-identifier;
 *         }
 *         leaf revision {
 *             type optional-revision;
 *         }
 *         uses module-list;
 *     }
 *     leaf conformance-type {
 *         type enumeration;
 *     }
 *     container submodules {
 *         list submodule {
 *             key "name" "revision";
 *             leaf name {
 *                 type yang-identifier;
 *             }
 *             leaf revision {
 *                 type optional-revision;
 *             }
 *             leaf schema {
 *                 type uri;
 *             }
 *             uses module-list;
 *             uses module-list;
 *         }
 *     }
 *     uses module-list;
 *     uses module-list;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/module-list/module</i>
 *
 * <p>To create instances of this class use {@link ModuleBuilder}.
 * @see ModuleBuilder
 * @see ModuleKey
 *
 */
public interface Module
    extends
    ChildOf<ModuleList>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>,
    CommonLeafs,
    SchemaLeaf,
    Identifiable<ModuleKey>
{


    public enum ConformanceType {
        /**
         * Indicates that the server implements one or moreprotocol-accessible objects 
         * defined in the YANG moduleidentified in this entry. This includes 
         * deviationstatements defined in the module.For YANG version 1.1 modules, there is
         * at most onemodule entry with conformance type 'implement' for aparticular module
         * name, since YANG 1.1 requires thatat most one revision of a module is 
         * implemented.For YANG version 1 modules, there SHOULD NOT be morethan one module 
         * entry for a particular module name.
         *
         */
        Implement(0, "implement"),
        
        /**
         * Indicates that the server imports reusable definitionsfrom the specified 
         * revision of the module, but doesnot implement any protocol accessible objects 
         * fromthis revision.Multiple module entries for the same module name MAYexist. 
         * This can occur if multiple modules import thesame module, but specify different 
         * revision-dates inthe import statements.
         *
         */
        Import(1, "import")
        ;
    
        private static final java.util.Map<java.lang.Integer, ConformanceType> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ConformanceType> b = com.google.common.collect.ImmutableMap.builder();
            for (ConformanceType enumItem : ConformanceType.values()) {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private final java.lang.String name;
        private final int value;
    
        private ConformanceType(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg integer value
         * @return corresponding ConformanceType item
         */
        public static ConformanceType forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "module").intern();

    /**
     * The XML namespace identifier for this module.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri</code> <code>namespace</code>, or <code>null</code> if not present
     */
    Uri getNamespace();
    
    /**
     * List of YANG feature names from this module that aresupported by the server, 
     * regardless whether they aredefined in the module or any included submodule.
     *
     *
     *
     * @return <code>java.util.List</code> <code>feature</code>, or <code>null</code> if not present
     */
    List<YangIdentifier> getFeature();
    
    /**
     * List of YANG deviation module names and revisionsused by this server to modify 
     * the conformance ofthe module associated with this entry. Note thatthe same 
     * module can be used for deviations formultiple modules, so the same entry MAY 
     * appearwithin multiple 'module' entries.The deviation module MUST be present in 
     * the 'module'list, with the same name and revision values.The 'conformance-type' 
     * value will be 'implement' forthe deviation module.
     *
     *
     *
     * @return <code>java.util.List</code> <code>deviation</code>, or <code>null</code> if not present
     */
    List<Deviation> getDeviation();
    
    /**
     * Indicates the type of conformance the server is claimingfor the YANG module 
     * identified by this entry.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module.ConformanceType</code> <code>conformanceType</code>, or <code>null</code> if not present
     */
    ConformanceType getConformanceType();
    
    /**
     * Contains information about all the submodules usedby the parent module entry
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Submodules</code> <code>submodules</code>, or <code>null</code> if not present
     */
    Submodules getSubmodules();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.ModuleKey</code> <code>key</code>, or <code>null</code> if not present
     */
    ModuleKey getKey();

}

