package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Submodules;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.OptionalRevision;
import java.util.Objects;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module.ConformanceType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Deviation;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module
 *
 */
public class ModuleBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module> {

    private ConformanceType _conformanceType;
    private List<Deviation> _deviation;
    private List<YangIdentifier> _feature;
    private ModuleKey _key;
    private YangIdentifier _name;
    private Uri _namespace;
    private OptionalRevision _revision;
    private Uri _schema;
    private Submodules _submodules;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>>, Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> augmentation = Collections.emptyMap();

    public ModuleBuilder() {
    }
    public ModuleBuilder(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs arg) {
        this._name = arg.getName();
        this._revision = arg.getRevision();
    }
    public ModuleBuilder(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.SchemaLeaf arg) {
        this._schema = arg.getSchema();
    }

    public ModuleBuilder(Module base) {
        if (base.getKey() == null) {
            this._key = new ModuleKey(
                base.getName(), 
                base.getRevision()
            );
            this._name = base.getName();
            this._revision = base.getRevision();
        } else {
            this._key = base.getKey();
            this._name = _key.getName();
            this._revision = _key.getRevision();
        }
        this._conformanceType = base.getConformanceType();
        this._deviation = base.getDeviation();
        this._feature = base.getFeature();
        this._namespace = base.getNamespace();
        this._schema = base.getSchema();
        this._submodules = base.getSubmodules();
        if (base instanceof ModuleImpl) {
            ModuleImpl impl = (ModuleImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs</li>
     * <li>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.SchemaLeaf</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs) {
            this._name = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs)arg).getName();
            this._revision = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs)arg).getRevision();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.SchemaLeaf) {
            this._schema = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.SchemaLeaf)arg).getSchema();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.SchemaLeaf] \n" +
              "but was: " + arg
            );
        }
    }

    public ConformanceType getConformanceType() {
        return _conformanceType;
    }
    
    public List<Deviation> getDeviation() {
        return _deviation;
    }
    
    public List<YangIdentifier> getFeature() {
        return _feature;
    }
    
    public ModuleKey getKey() {
        return _key;
    }
    
    public YangIdentifier getName() {
        return _name;
    }
    
    public Uri getNamespace() {
        return _namespace;
    }
    
    public OptionalRevision getRevision() {
        return _revision;
    }
    
    public Uri getSchema() {
        return _schema;
    }
    
    public Submodules getSubmodules() {
        return _submodules;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ModuleBuilder setConformanceType(final ConformanceType value) {
        this._conformanceType = value;
        return this;
    }
    
     
    public ModuleBuilder setDeviation(final List<Deviation> value) {
        this._deviation = value;
        return this;
    }
    
     
    public ModuleBuilder setFeature(final List<YangIdentifier> value) {
        this._feature = value;
        return this;
    }
    
     
    public ModuleBuilder setKey(final ModuleKey value) {
        this._key = value;
        return this;
    }
    
     
    public ModuleBuilder setName(final YangIdentifier value) {
        this._name = value;
        return this;
    }
    
     
    public ModuleBuilder setNamespace(final Uri value) {
        this._namespace = value;
        return this;
    }
    
     
    public ModuleBuilder setRevision(final OptionalRevision value) {
        this._revision = value;
        return this;
    }
    
     
    public ModuleBuilder setSchema(final Uri value) {
        this._schema = value;
        return this;
    }
    
     
    public ModuleBuilder setSubmodules(final Submodules value) {
        this._submodules = value;
        return this;
    }
    
    public ModuleBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ModuleBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Module build() {
        return new ModuleImpl(this);
    }

    private static final class ModuleImpl implements Module {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module.class;
        }

        private final ConformanceType _conformanceType;
        private final List<Deviation> _deviation;
        private final List<YangIdentifier> _feature;
        private final ModuleKey _key;
        private final YangIdentifier _name;
        private final Uri _namespace;
        private final OptionalRevision _revision;
        private final Uri _schema;
        private final Submodules _submodules;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>>, Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> augmentation = Collections.emptyMap();

        private ModuleImpl(ModuleBuilder base) {
            if (base.getKey() == null) {
                this._key = new ModuleKey(
                    base.getName(), 
                    base.getRevision()
                );
                this._name = base.getName();
                this._revision = base.getRevision();
            } else {
                this._key = base.getKey();
                this._name = _key.getName();
                this._revision = _key.getRevision();
            }
            this._conformanceType = base.getConformanceType();
            this._deviation = base.getDeviation();
            this._feature = base.getFeature();
            this._namespace = base.getNamespace();
            this._schema = base.getSchema();
            this._submodules = base.getSubmodules();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>>, Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>>, Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public ConformanceType getConformanceType() {
            return _conformanceType;
        }
        
        @Override
        public List<Deviation> getDeviation() {
            return _deviation;
        }
        
        @Override
        public List<YangIdentifier> getFeature() {
            return _feature;
        }
        
        @Override
        public ModuleKey getKey() {
            return _key;
        }
        
        @Override
        public YangIdentifier getName() {
            return _name;
        }
        
        @Override
        public Uri getNamespace() {
            return _namespace;
        }
        
        @Override
        public OptionalRevision getRevision() {
            return _revision;
        }
        
        @Override
        public Uri getSchema() {
            return _schema;
        }
        
        @Override
        public Submodules getSubmodules() {
            return _submodules;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_conformanceType);
            result = prime * result + Objects.hashCode(_deviation);
            result = prime * result + Objects.hashCode(_feature);
            result = prime * result + Objects.hashCode(_key);
            result = prime * result + Objects.hashCode(_name);
            result = prime * result + Objects.hashCode(_namespace);
            result = prime * result + Objects.hashCode(_revision);
            result = prime * result + Objects.hashCode(_schema);
            result = prime * result + Objects.hashCode(_submodules);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module other = (org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module)obj;
            if (!Objects.equals(_conformanceType, other.getConformanceType())) {
                return false;
            }
            if (!Objects.equals(_deviation, other.getDeviation())) {
                return false;
            }
            if (!Objects.equals(_feature, other.getFeature())) {
                return false;
            }
            if (!Objects.equals(_key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(_name, other.getName())) {
                return false;
            }
            if (!Objects.equals(_namespace, other.getNamespace())) {
                return false;
            }
            if (!Objects.equals(_revision, other.getRevision())) {
                return false;
            }
            if (!Objects.equals(_schema, other.getSchema())) {
                return false;
            }
            if (!Objects.equals(_submodules, other.getSubmodules())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ModuleImpl otherImpl = (ModuleImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>>, Augmentation<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Module [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_conformanceType != null) {
                builder.append("_conformanceType=");
                builder.append(_conformanceType);
                builder.append(", ");
            }
            if (_deviation != null) {
                builder.append("_deviation=");
                builder.append(_deviation);
                builder.append(", ");
            }
            if (_feature != null) {
                builder.append("_feature=");
                builder.append(_feature);
                builder.append(", ");
            }
            if (_key != null) {
                builder.append("_key=");
                builder.append(_key);
                builder.append(", ");
            }
            if (_name != null) {
                builder.append("_name=");
                builder.append(_name);
                builder.append(", ");
            }
            if (_namespace != null) {
                builder.append("_namespace=");
                builder.append(_namespace);
                builder.append(", ");
            }
            if (_revision != null) {
                builder.append("_revision=");
                builder.append(_revision);
                builder.append(", ");
            }
            if (_schema != null) {
                builder.append("_schema=");
                builder.append(_schema);
                builder.append(", ");
            }
            if (_submodules != null) {
                builder.append("_submodules=");
                builder.append(_submodules);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
