package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;

/**
 * Common schema leaf parameter for modules and submodules.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * grouping schema-leaf {
 *     leaf schema {
 *         type uri;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/module-list/schema-leaf</i>
 *
 */
public interface SchemaLeaf
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "schema-leaf").intern();

    /**
     * Contains a URL that represents the YANG schemaresource for this module or 
     * submodule.This leaf will only be present if there is a URLavailable for 
     * retrieval of the schema for this entry.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri</code> <code>schema</code>, or <code>null</code> if not present
     */
    Uri getSchema();

}

