package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * List of YANG deviation module names and revisionsused by this server to modify 
 * the conformance ofthe module associated with this entry. Note thatthe same 
 * module can be used for deviations formultiple modules, so the same entry MAY 
 * appearwithin multiple 'module' entries.The deviation module MUST be present in 
 * the 'module'list, with the same name and revision values.The 'conformance-type' 
 * value will be 'implement' forthe deviation module.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * list deviation {
 *     key "name" "revision";
 *     leaf name {
 *         type yang-identifier;
 *     }
 *     leaf revision {
 *         type optional-revision;
 *     }
 *     uses module-list;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/module-list/module/deviation</i>
 *
 * <p>To create instances of this class use {@link DeviationBuilder}.
 * @see DeviationBuilder
 * @see DeviationKey
 *
 */
public interface Deviation
    extends
    ChildOf<Module>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Deviation>,
    CommonLeafs,
    Identifiable<DeviationKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "deviation").intern();

    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.DeviationKey</code> <code>key</code>, or <code>null</code> if not present
     */
    DeviationKey getKey();

}

