package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.OptionalRevision;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;

public class DeviationKey
 implements Identifier<Deviation> {
    private static final long serialVersionUID = 2574426202177000493L;
    private final YangIdentifier _name;
    private final OptionalRevision _revision;


    public DeviationKey(YangIdentifier _name, OptionalRevision _revision) {
    
    
        this._name = _name;
        this._revision = _revision;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public DeviationKey(DeviationKey source) {
        this._name = source._name;
        this._revision = source._revision;
    }


    public YangIdentifier getName() {
        return _name;
    }
    
    public OptionalRevision getRevision() {
        return _revision;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_name);
        result = prime * result + Objects.hashCode(_revision);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        DeviationKey other = (DeviationKey) obj;
        if (!Objects.equals(_name, other._name)) {
            return false;
        }
        if (!Objects.equals(_revision, other._revision)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.DeviationKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_name != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_name=");
            builder.append(_name);
        }
        if (_revision != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_revision=");
            builder.append(_revision);
        }
        return builder.append(']').toString();
    }
}

