package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.submodules.Submodule;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.Module;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * Contains information about all the submodules usedby the parent module entry
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * container submodules {
 *     list submodule {
 *         key "name" "revision";
 *         leaf name {
 *             type yang-identifier;
 *         }
 *         leaf revision {
 *             type optional-revision;
 *         }
 *         leaf schema {
 *             type uri;
 *         }
 *         uses module-list;
 *         uses module-list;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/module-list/module/submodules</i>
 *
 * <p>To create instances of this class use {@link SubmodulesBuilder}.
 * @see SubmodulesBuilder
 *
 */
public interface Submodules
    extends
    ChildOf<Module>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Submodules>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "submodules").intern();

    /**
     * Each entry represents one submodule within theparent module.
     *
     *
     *
     * @return <code>java.util.List</code> <code>submodule</code>, or <code>null</code> if not present
     */
    List<Submodule> getSubmodule();

}

