package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.submodules;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.Submodules;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.CommonLeafs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.SchemaLeaf;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * Each entry represents one submodule within theparent module.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-yang-library</b>
 * <pre>
 * list submodule {
 *     key "name" "revision";
 *     leaf name {
 *         type yang-identifier;
 *     }
 *     leaf revision {
 *         type optional-revision;
 *     }
 *     leaf schema {
 *         type uri;
 *     }
 *     uses module-list;
 *     uses module-list;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-yang-library/module-list/module/submodules/submodule</i>
 *
 * <p>To create instances of this class use {@link SubmoduleBuilder}.
 * @see SubmoduleBuilder
 * @see SubmoduleKey
 *
 */
public interface Submodule
    extends
    ChildOf<Submodules>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.submodules.Submodule>,
    CommonLeafs,
    SchemaLeaf,
    Identifiable<SubmoduleKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "2016-04-09", "submodule").intern();

    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.module.list.module.submodules.SubmoduleKey</code> <code>key</code>, or <code>null</code> if not present
     */
    SubmoduleKey getKey();

}

