/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.yang.library;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.datastores.rev180214.Operational;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.ModulesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.ModulesStateBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibrary;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibraryBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.CommonLeafsRevisionBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.Module;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.module.SubmoduleBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.set.parameters.ImportOnlyModuleRevisionBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.set.parameters.ModuleBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.yang.library.parameters.DatastoreBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.yang.library.parameters.ModuleSetBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.yang.library.parameters.SchemaBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true, service={})
public class YangLibraryWriter
implements EffectiveModelContextListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(YangLibraryWriter.class);
    private static final String MODULE_SET_NAME = "state-modules";
    private static final String SCHEMA_NAME = "state-schema";
    private static final InstanceIdentifier<YangLibrary> YANG_LIBRARY_INSTANCE_IDENTIFIER = InstanceIdentifier.create(YangLibrary.class);
    @Deprecated
    private static final InstanceIdentifier<ModulesState> MODULES_STATE_INSTANCE_IDENTIFIER = InstanceIdentifier.create(ModulesState.class);
    private final DataBroker dataBroker;
    private @GuardedBy(value={"this"}) long moduleSetId;
    private @GuardedBy(value={"this"}) ListenerRegistration<?> reg;

    @Inject
    @Activate
    public YangLibraryWriter(@Reference DOMSchemaService schemaService, @Reference DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.reg = schemaService.registerSchemaContextListener((EffectiveModelContextListener)this);
    }

    @Override
    @PreDestroy
    @Deactivate
    public synchronized void close() throws InterruptedException, ExecutionException {
        if (this.reg == null) {
            return;
        }
        this.reg.close();
        this.reg = null;
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, YANG_LIBRARY_INSTANCE_IDENTIFIER);
        tx.delete(LogicalDatastoreType.OPERATIONAL, MODULES_STATE_INSTANCE_IDENTIFIER);
        FluentFuture future = tx.commit();
        future.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo info) {
                LOG.debug("YANG library cleared successfully");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to clear YANG library", throwable);
            }
        }, MoreExecutors.directExecutor());
        future.get();
    }

    public void onModelContextUpdated(EffectiveModelContext context) {
        Module ietfYangLibraryModule = context.findModule(YangLibrary.QNAME.getModule()).orElse(null);
        if (ietfYangLibraryModule != null) {
            this.updateYangLibrary(context);
        } else {
            LOG.debug("ietf-yang-library not present in context, skipping update");
        }
    }

    private synchronized void updateYangLibrary(EffectiveModelContext context) {
        if (this.reg == null) {
            return;
        }
        long currentSetId = this.moduleSetId++;
        YangLibrary newYangLibrary = YangLibraryWriter.createYangLibraryFromContext(context.getModules(), currentSetId);
        ModulesState newModuleState = YangLibraryWriter.createModuleStateFromModules(context.getModules(), currentSetId);
        LOG.debug("Trying to write new yang-library: {}", (Object)newYangLibrary);
        LOG.debug("Trying to write new module-state: {}", (Object)newModuleState);
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, YANG_LIBRARY_INSTANCE_IDENTIFIER, (DataObject)newYangLibrary);
        tx.put(LogicalDatastoreType.OPERATIONAL, MODULES_STATE_INSTANCE_IDENTIFIER, (DataObject)newModuleState);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("Yang library updated successfully");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Failed to update yang library", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private static YangLibrary createYangLibraryFromContext(Collection<? extends Module> modules, long moduleSetId) {
        Map moduleMap = (Map)modules.stream().map(module -> {
            Map submoduleMap = (Map)module.getSubmodules().stream().map(subModule -> new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.set.parameters.module.SubmoduleBuilder().setName(new YangIdentifier(subModule.getName())).setRevision(ImportOnlyModuleRevisionBuilder.fromYangCommon((Optional)subModule.getQNameModule().getRevision()).getRevisionIdentifier()).build()).collect(BindingMap.toMap());
            return new ModuleBuilder().setName(new YangIdentifier(module.getName() + "_" + (String)module.getRevision().map(Revision::toString).orElse(null))).setRevision(ImportOnlyModuleRevisionBuilder.fromYangCommon((Optional)module.getQNameModule().getRevision()).getRevisionIdentifier()).setNamespace(new Uri(module.getNamespace().toString())).setSubmodule(submoduleMap).build();
        }).collect(BindingMap.toMap());
        return new YangLibraryBuilder().setModuleSet(BindingMap.of((Identifiable)new ModuleSetBuilder().setName(MODULE_SET_NAME).setModule(moduleMap).build())).setSchema(BindingMap.of((Identifiable)new SchemaBuilder().setName(SCHEMA_NAME).setModuleSet(List.of(MODULE_SET_NAME)).build())).setDatastore(BindingMap.of((Identifiable)new DatastoreBuilder().setName(Operational.class).setSchema(SCHEMA_NAME).build())).setContentId(String.valueOf(moduleSetId)).build();
    }

    @Deprecated
    private static ModulesState createModuleStateFromModules(Collection<? extends Module> modules, long moduleSetId) {
        Map moduleMap = (Map)modules.stream().map(module -> {
            Map submoduleMap = (Map)module.getSubmodules().stream().map(subModule -> new SubmoduleBuilder().setName(new YangIdentifier(subModule.getName())).setRevision(CommonLeafsRevisionBuilder.fromYangCommon((Optional)subModule.getQNameModule().getRevision())).build()).collect(BindingMap.toMap());
            return new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.ModuleBuilder().setName(new YangIdentifier(module.getName())).setRevision(CommonLeafsRevisionBuilder.fromYangCommon((Optional)module.getQNameModule().getRevision())).setNamespace(new Uri(module.getNamespace().toString())).setConformanceType(Module.ConformanceType.Implement).setSubmodule(submoduleMap).build();
        }).collect(BindingMap.toMap());
        return new ModulesStateBuilder().setModule(moduleMap).setModuleSetId(String.valueOf(moduleSetId)).build();
    }
}

