/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mapping.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public final class HandlingPriority
implements Comparable<HandlingPriority> {
    public static final HandlingPriority CANNOT_HANDLE = new HandlingPriority();
    public static final HandlingPriority HANDLE_WITH_DEFAULT_PRIORITY = new HandlingPriority(Integer.MIN_VALUE);
    public static final HandlingPriority HANDLE_WITH_MAX_PRIORITY = new HandlingPriority(Integer.MAX_VALUE);
    private Integer priority;

    public static HandlingPriority getHandlingPriority(int priority) {
        return new HandlingPriority(priority);
    }

    private HandlingPriority(int priority) {
        this.priority = priority;
    }

    private HandlingPriority() {
    }

    public Optional<Integer> getPriority() {
        return Optional.ofNullable(this.priority);
    }

    public HandlingPriority increasePriority(int priorityIncrease) {
        Preconditions.checkState((this.priority != null ? 1 : 0) != 0, (String)"Unable to increase priority for %s", (Object)this);
        Preconditions.checkArgument((priorityIncrease > 0 ? 1 : 0) != 0, (Object)"Negative increase");
        Preconditions.checkArgument((Long.valueOf(this.priority.intValue()) + (long)priorityIncrease < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Resulting priority cannot be higher than %s", (int)Integer.MAX_VALUE);
        return HandlingPriority.getHandlingPriority(this.priority + priorityIncrease);
    }

    public boolean isCannotHandle() {
        return this.equals(CANNOT_HANDLE);
    }

    @Override
    public int compareTo(HandlingPriority o) {
        if (this == o) {
            return 0;
        }
        if (this.isCannotHandle()) {
            return -1;
        }
        if (o.isCannotHandle()) {
            return 1;
        }
        if (this.priority > o.priority) {
            return 1;
        }
        if (this.priority.equals(o.priority)) {
            return 0;
        }
        if (this.priority < o.priority) {
            return -1;
        }
        throw new IllegalStateException("Unexpected state comparing " + this + " with " + this.priority);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HandlingPriority)) {
            return false;
        }
        HandlingPriority that = (HandlingPriority)obj;
        return Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return this.priority != null ? this.priority.hashCode() : 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("priority", (Object)this.priority).toString();
    }
}

