/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class NetconfXMLToHelloMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfXMLToHelloMessageDecoder.class);
    private static final List<byte[]> POSSIBLE_ENDS = ImmutableList.of((Object)new byte[]{93, 10}, (Object)new byte[]{93, 13, 10});
    private static final List<byte[]> POSSIBLE_STARTS = ImmutableList.of((Object)new byte[]{91}, (Object)new byte[]{13, 10, 91}, (Object)new byte[]{10, 91});
    private final List<NetconfMessage> nonHelloMessages = Lists.newArrayList();
    private boolean helloReceived = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException, SAXException, NetconfDocumentedException {
        if (in.readableBytes() == 0) {
            LOG.debug("No more content in incoming buffer.");
            return;
        }
        in.markReaderIndex();
        try {
            Document doc;
            NetconfMessage message;
            int endOfAuthHeader;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
            }
            byte[] bytes = new byte[in.readableBytes()];
            in.readBytes(bytes);
            NetconfXMLToHelloMessageDecoder.logMessage(bytes);
            String additionalHeader = null;
            if (NetconfXMLToHelloMessageDecoder.startsWithAdditionalHeader(bytes) && (endOfAuthHeader = NetconfXMLToHelloMessageDecoder.getAdditionalHeaderEndIndex(bytes)) > -1) {
                byte[] additionalHeaderBytes = Arrays.copyOfRange(bytes, 0, endOfAuthHeader);
                additionalHeader = NetconfXMLToHelloMessageDecoder.additionalHeaderToString(additionalHeaderBytes);
                bytes = Arrays.copyOfRange(bytes, endOfAuthHeader, bytes.length);
            }
            if ((message = NetconfXMLToHelloMessageDecoder.getNetconfMessage(additionalHeader, doc = XmlUtil.readXmlToDocument((InputStream)new ByteArrayInputStream(bytes)))) instanceof NetconfHelloMessage) {
                Preconditions.checkState((!this.helloReceived ? 1 : 0) != 0, (String)"Multiple hello messages received, unexpected hello: %s", (Object[])new Object[]{message});
                out.add(message);
                this.helloReceived = true;
            } else {
                Preconditions.checkState((boolean)this.helloReceived, (String)"Hello message not received, instead received: %s", (Object[])new Object[]{message});
                LOG.debug("Netconf message received during negotiation, caching {}", (Object)message);
                this.nonHelloMessages.add(message);
            }
        }
        finally {
            in.discardReadBytes();
        }
    }

    private static NetconfMessage getNetconfMessage(String additionalHeader, Document doc) throws NetconfDocumentedException {
        NetconfMessage msg = new NetconfMessage(doc);
        if (NetconfHelloMessage.isHelloMessage((NetconfMessage)msg)) {
            if (additionalHeader != null) {
                return new NetconfHelloMessage(doc, NetconfHelloMessageAdditionalHeader.fromString((String)additionalHeader));
            }
            return new NetconfHelloMessage(doc);
        }
        return msg;
    }

    private static int getAdditionalHeaderEndIndex(byte[] bytes) {
        for (byte[] possibleEnd : POSSIBLE_ENDS) {
            int idx = NetconfXMLToHelloMessageDecoder.findByteSequence(bytes, possibleEnd);
            if (idx == -1) continue;
            return idx + possibleEnd.length;
        }
        return -1;
    }

    private static int findByteSequence(byte[] bytes, byte[] sequence) {
        if (bytes.length < sequence.length) {
            throw new IllegalArgumentException("Sequence to be found is longer than the given byte array.");
        }
        if (bytes.length == sequence.length) {
            if (Arrays.equals(bytes, sequence)) {
                return 0;
            }
            return -1;
        }
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == sequence[j]) {
                if (++j != sequence.length) continue;
                return i - j + 1;
            }
            j = 0;
        }
        return -1;
    }

    private static void logMessage(byte[] bytes) {
        if (LOG.isDebugEnabled()) {
            String s = Charsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString();
            LOG.debug("Parsing message \n{}", (Object)s);
        }
    }

    private static boolean startsWithAdditionalHeader(byte[] bytes) {
        for (byte[] possibleStart : POSSIBLE_STARTS) {
            int i = 0;
            for (byte b : possibleStart) {
                if (bytes[i++] != b) break;
                if (i != possibleStart.length) continue;
                return true;
            }
        }
        return false;
    }

    private static String additionalHeaderToString(byte[] bytes) {
        return Charsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public Iterable<NetconfMessage> getPostHelloNetconfMessages() {
        return this.nonHelloMessages;
    }
}

