/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.Promise;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.nettyutil.AbstractChannelInitializer;

public class AbstractChannelInitializerTest {
    @Mock
    private Channel channel;
    @Mock
    private ChannelPipeline pipeline;
    @Mock
    private Promise<NetconfSession> sessionPromise;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((Channel)Mockito.doReturn((Object)this.pipeline).when((Object)this.channel)).pipeline();
        ((ChannelPipeline)Mockito.doReturn((Object)this.pipeline).when((Object)this.pipeline)).addLast(Matchers.anyString(), (ChannelHandler)Matchers.any(ChannelHandler.class));
    }

    @Test
    public void testInit() throws Exception {
        TestingInitializer testingInitializer = new TestingInitializer();
        testingInitializer.initialize(this.channel, this.sessionPromise);
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline, (VerificationMode)Mockito.times((int)4))).addLast(Matchers.anyString(), (ChannelHandler)Matchers.any(ChannelHandler.class));
    }

    private static final class TestingInitializer
    extends AbstractChannelInitializer<NetconfSession> {
        private TestingInitializer() {
        }

        protected void initializeSessionNegotiator(Channel ch, Promise<NetconfSession> promise) {
        }
    }
}

