/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import com.google.common.base.Optional;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.NetconfTerminationReason;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSession;
import org.opendaylight.netconf.nettyutil.handler.exi.NetconfStartExiMessage;
import org.opendaylight.protocol.framework.ProtocolSession;
import org.opendaylight.protocol.framework.TerminationReason;
import org.openexi.proc.common.EXIOptions;

public class AbstractNetconfSessionTest {
    @Mock
    private NetconfSessionListener<NetconfSession> listener;
    @Mock
    private Channel channel;
    @Mock
    private ChannelPipeline pipeline;
    @Mock
    private EventLoop eventLoop;
    @Mock
    private ChannelFuture writeFuture;
    private NetconfHelloMessage clientHello;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((NetconfSessionListener)Mockito.doNothing().when(this.listener)).onMessage((ProtocolSession)Matchers.any(NetconfSession.class), Matchers.any(NetconfMessage.class));
        ((NetconfSessionListener)Mockito.doNothing().when(this.listener)).onSessionUp((ProtocolSession)Matchers.any(NetconfSession.class));
        ((NetconfSessionListener)Mockito.doNothing().when(this.listener)).onSessionDown((ProtocolSession)Matchers.any(NetconfSession.class), (Exception)Matchers.any(Exception.class));
        ((NetconfSessionListener)Mockito.doNothing().when(this.listener)).onSessionTerminated((ProtocolSession)Matchers.any(NetconfSession.class), (TerminationReason)Matchers.any(NetconfTerminationReason.class));
        ((ChannelFuture)Mockito.doReturn((Object)this.writeFuture).when((Object)this.writeFuture)).addListener((GenericFutureListener)Matchers.any(GenericFutureListener.class));
        ((Channel)Mockito.doReturn((Object)this.writeFuture).when((Object)this.channel)).writeAndFlush(Matchers.any(NetconfMessage.class));
        ((Channel)Mockito.doReturn((Object)this.pipeline).when((Object)this.channel)).pipeline();
        ((Channel)Mockito.doReturn((Object)"mockChannel").when((Object)this.channel)).toString();
        ((Channel)Mockito.doReturn((Object)Mockito.mock(ChannelFuture.class)).when((Object)this.channel)).close();
        ((ChannelPipeline)Mockito.doReturn(null).when((Object)this.pipeline)).replace(Matchers.anyString(), Matchers.anyString(), (ChannelHandler)Matchers.any(ChannelHandler.class));
        ((Channel)Mockito.doReturn((Object)this.eventLoop).when((Object)this.channel)).eventLoop();
        ((EventLoop)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Runnable runnable = (Runnable)args[0];
                runnable.run();
                return null;
            }
        }).when((Object)this.eventLoop)).execute((Runnable)Matchers.any(Runnable.class));
        this.clientHello = NetconfHelloMessage.createClientHello(Collections.emptySet(), (Optional)Optional.absent());
    }

    @Test
    public void testHandleMessage() throws Exception {
        TestingNetconfSession testingNetconfSession = new TestingNetconfSession(this.listener, this.channel, 1L);
        testingNetconfSession.handleMessage((NetconfMessage)this.clientHello);
        ((NetconfSessionListener)Mockito.verify(this.listener)).onMessage((ProtocolSession)testingNetconfSession, (Object)this.clientHello);
    }

    @Test
    public void testSessionUp() throws Exception {
        TestingNetconfSession testingNetconfSession = new TestingNetconfSession(this.listener, this.channel, 1L);
        testingNetconfSession.sessionUp();
        ((NetconfSessionListener)Mockito.verify(this.listener)).onSessionUp((ProtocolSession)testingNetconfSession);
        Assert.assertEquals((long)1L, (long)testingNetconfSession.getSessionId());
    }

    @Test
    public void testClose() throws Exception {
        TestingNetconfSession testingNetconfSession = new TestingNetconfSession(this.listener, this.channel, 1L);
        testingNetconfSession.sessionUp();
        testingNetconfSession.close();
        ((Channel)Mockito.verify((Object)this.channel)).close();
        ((NetconfSessionListener)Mockito.verify(this.listener)).onSessionTerminated((ProtocolSession)Matchers.any(NetconfSession.class), (TerminationReason)Matchers.any(NetconfTerminationReason.class));
    }

    @Test
    public void testReplaceHandlers() throws Exception {
        TestingNetconfSession testingNetconfSession = new TestingNetconfSession(this.listener, this.channel, 1L);
        ChannelHandler mock = (ChannelHandler)Mockito.mock(ChannelHandler.class);
        ((ChannelHandler)Mockito.doReturn((Object)"handler").when((Object)mock)).toString();
        testingNetconfSession.replaceMessageDecoder(mock);
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).replace("netconfMessageDecoder", "netconfMessageDecoder", mock);
        testingNetconfSession.replaceMessageEncoder(mock);
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).replace("netconfMessageEncoder", "netconfMessageEncoder", mock);
        testingNetconfSession.replaceMessageEncoderAfterNextMessage(mock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.pipeline});
        testingNetconfSession.sendMessage((NetconfMessage)this.clientHello);
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline, (VerificationMode)Mockito.times((int)2))).replace("netconfMessageEncoder", "netconfMessageEncoder", mock);
    }

    @Test
    public void testStartExi() throws Exception {
        TestingNetconfSession testingNetconfSession = new TestingNetconfSession(this.listener, this.channel, 1L);
        testingNetconfSession = (TestingNetconfSession)((Object)Mockito.spy((Object)((Object)testingNetconfSession)));
        testingNetconfSession.startExiCommunication((NetconfMessage)NetconfStartExiMessage.create((EXIOptions)new EXIOptions(), (String)"4"));
        ((TestingNetconfSession)((Object)Mockito.verify((Object)((Object)testingNetconfSession)))).addExiHandlers((ByteToMessageDecoder)Matchers.any(ByteToMessageDecoder.class), (MessageToByteEncoder<NetconfMessage>)((MessageToByteEncoder)Matchers.any(MessageToByteEncoder.class)));
    }

    @Test
    public void testEndOfInput() throws Exception {
        TestingNetconfSession testingNetconfSession = new TestingNetconfSession(this.listener, this.channel, 1L);
        testingNetconfSession.endOfInput();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listener});
        testingNetconfSession.sessionUp();
        testingNetconfSession.endOfInput();
        ((NetconfSessionListener)Mockito.verify(this.listener)).onSessionDown((ProtocolSession)Matchers.any(NetconfSession.class), (Exception)Matchers.any(Exception.class));
    }

    @Test
    public void testSendMessage() throws Exception {
        TestingNetconfSession testingNetconfSession = new TestingNetconfSession(this.listener, this.channel, 1L);
        NetconfHelloMessage clientHello = NetconfHelloMessage.createClientHello(Collections.emptySet(), (Optional)Optional.absent());
        testingNetconfSession.sendMessage((NetconfMessage)clientHello);
        ((Channel)Mockito.verify((Object)this.channel)).writeAndFlush((Object)clientHello);
    }

    private static class TestingNetconfSession
    extends AbstractNetconfSession<NetconfSession, NetconfSessionListener<NetconfSession>> {
        protected TestingNetconfSession(NetconfSessionListener<NetconfSession> sessionListener, Channel channel, long sessionId) {
            super(sessionListener, channel, sessionId);
        }

        protected NetconfSession thisInstance() {
            return this;
        }

        protected void addExiHandlers(ByteToMessageDecoder decoder, MessageToByteEncoder<NetconfMessage> encoder) {
        }

        public void stopExiCommunication() {
        }
    }
}

