/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.netconf.nettyutil.handler.ChunkedFramingMechanismEncoder;

public class ChunkedFramingMechanismEncoderTest {
    private int chunkSize;
    @Mock
    private ChannelHandlerContext ctx;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.chunkSize = 256;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalSize() throws Exception {
        new ChunkedFramingMechanismEncoder(10);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalSizeMax() throws Exception {
        new ChunkedFramingMechanismEncoder(Integer.MAX_VALUE);
    }

    @Test
    public void testEncode() throws Exception {
        ChunkedFramingMechanismEncoder encoder = new ChunkedFramingMechanismEncoder(this.chunkSize);
        int lastChunkSize = 20;
        ByteBuf src = Unpooled.wrappedBuffer((byte[])ChunkedFramingMechanismEncoderTest.getByteArray(this.chunkSize * 4 + 20));
        ByteBuf destination = Unpooled.buffer();
        encoder.encode(this.ctx, src, destination);
        Assert.assertEquals((long)1077L, (long)destination.readableBytes());
        byte[] buf = new byte[destination.readableBytes()];
        destination.readBytes(buf);
        String s = StandardCharsets.US_ASCII.decode(ByteBuffer.wrap(buf)).toString();
        Assert.assertTrue((boolean)s.startsWith("\n#256\na"));
        Assert.assertTrue((boolean)s.endsWith("\n#20\naaaaaaaaaaaaaaaaaaaa\n##\n"));
    }

    private static byte[] getByteArray(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = 97;
        }
        return bytes;
    }
}

