/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opendaylight.netconf.nettyutil.handler.NetconfChunkAggregator;

public class NetconfChunkAggregatorTest {
    private static final String CHUNKED_MESSAGE = "\n#4\n<rpc\n#18\n message-id=\"102\"\n\n#79\n     xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n  <close-session/>\n</rpc>\n##\n";
    public static final String EXPECTED_MESSAGE = "<rpc message-id=\"102\"\n     xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n  <close-session/>\n</rpc>";
    private static final String CHUNKED_MESSAGE_ONE = "\n#101\n<rpc message-id=\"102\"\n     xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n  <close-session/>\n</rpc>\n##\n";
    private static NetconfChunkAggregator agr;

    @BeforeClass
    public static void setUp() throws Exception {
        agr = new NetconfChunkAggregator();
    }

    @Test
    public void testMultipleChunks() throws Exception {
        ArrayList output = Lists.newArrayList();
        ByteBuf input = Unpooled.copiedBuffer((byte[])CHUNKED_MESSAGE.getBytes(StandardCharsets.UTF_8));
        agr.decode(null, input, (List)output);
        Assert.assertEquals((long)1L, (long)output.size());
        ByteBuf chunk = (ByteBuf)output.get(0);
        Assert.assertEquals((Object)EXPECTED_MESSAGE, (Object)chunk.toString(StandardCharsets.UTF_8));
    }

    @Test
    public void testOneChunks() throws Exception {
        ArrayList output = Lists.newArrayList();
        ByteBuf input = Unpooled.copiedBuffer((byte[])CHUNKED_MESSAGE_ONE.getBytes(StandardCharsets.UTF_8));
        agr.decode(null, input, (List)output);
        Assert.assertEquals((long)1L, (long)output.size());
        ByteBuf chunk = (ByteBuf)output.get(0);
        Assert.assertEquals((Object)EXPECTED_MESSAGE, (Object)chunk.toString(StandardCharsets.UTF_8));
    }
}

