/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.nettyutil.handler.NetconfEXICodec;
import org.opendaylight.netconf.nettyutil.handler.NetconfEXIToMessageDecoder;
import org.opendaylight.netconf.nettyutil.handler.NetconfMessageToEXIEncoder;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.sax.Transmogrifier;
import org.openexi.sax.TransmogrifierException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class NetconfEXIHandlersTest {
    private final String msgAsString = "<netconf-message/>";
    private NetconfMessageToEXIEncoder netconfMessageToEXIEncoder;
    private NetconfEXIToMessageDecoder netconfEXIToMessageDecoder;
    private NetconfMessage msg;
    private byte[] msgAsExi;

    @Before
    public void setUp() throws Exception {
        NetconfEXICodec codec = new NetconfEXICodec(new EXIOptions());
        this.netconfMessageToEXIEncoder = NetconfMessageToEXIEncoder.create((NetconfEXICodec)codec);
        this.netconfEXIToMessageDecoder = NetconfEXIToMessageDecoder.create((NetconfEXICodec)codec);
        this.msg = new NetconfMessage(XmlUtil.readXmlToDocument((String)"<netconf-message/>"));
        this.msgAsExi = NetconfEXIHandlersTest.msgToExi("<netconf-message/>", codec);
    }

    private static byte[] msgToExi(String msgAsString, NetconfEXICodec codec) throws EXIOptionsException, TransmogrifierException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Transmogrifier transmogrifier = codec.getTransmogrifier();
        transmogrifier.setOutputStream((OutputStream)byteArrayOutputStream);
        transmogrifier.encode(new InputSource(new ByteArrayInputStream(msgAsString.getBytes())));
        return byteArrayOutputStream.toByteArray();
    }

    @Test
    public void testEncodeDecode() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        this.netconfMessageToEXIEncoder.encode(null, this.msg, buffer);
        int exiLength = this.msgAsExi.length;
        Assert.assertArrayEquals((byte[])this.msgAsExi, (byte[])Arrays.copyOfRange(buffer.array(), 0, exiLength));
        for (int i = exiLength; i < buffer.array().length; ++i) {
            Assert.assertEquals((long)0L, (long)buffer.array()[i]);
        }
        ArrayList out = Lists.newArrayList();
        this.netconfEXIToMessageDecoder.decode(null, buffer, (List)out);
        XMLUnit.compareXML((Document)this.msg.getDocument(), (Document)((NetconfMessage)out.get(0)).getDocument());
    }
}

