/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.nettyutil.handler.NetconfHelloMessageToXMLEncoder;

public class NetconfHelloMessageToXMLEncoderTest {
    @Mock
    private ChannelHandlerContext ctx;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testEncode() throws Exception {
        NetconfHelloMessage msg = new NetconfHelloMessage(XmlUtil.readXmlToDocument((String)"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>"), NetconfHelloMessageAdditionalHeader.fromString((String)"[tomas;10.0.0.0:10000;tcp;client;]"));
        ByteBuf destination = Unpooled.buffer();
        new NetconfHelloMessageToXMLEncoder().encode(this.ctx, (NetconfMessage)msg, destination);
        String encoded = new String(destination.array());
        Assert.assertThat((Object)encoded, (Matcher)CoreMatchers.containsString((String)"[tomas;10.0.0.0:10000;tcp;client;]"));
        Assert.assertThat((Object)encoded, (Matcher)CoreMatchers.containsString((String)"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>"));
    }

    @Test
    public void testEncodeNoHeader() throws Exception {
        NetconfHelloMessage msg = new NetconfHelloMessage(XmlUtil.readXmlToDocument((String)"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>"));
        ByteBuf destination = Unpooled.buffer();
        new NetconfHelloMessageToXMLEncoder().encode(this.ctx, (NetconfMessage)msg, destination);
        String encoded = new String(destination.array());
        Assert.assertThat((Object)encoded, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"[tomas;10.0.0.0:10000;tcp;client;]")));
        Assert.assertThat((Object)encoded, (Matcher)CoreMatchers.containsString((String)"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>"));
    }

    @Test(expected=IllegalStateException.class)
    public void testEncodeNotHello() throws Exception {
        NetconfMessage msg = new NetconfMessage(XmlUtil.readXmlToDocument((String)"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>"));
        new NetconfHelloMessageToXMLEncoder().encode(this.ctx, msg, null);
    }
}

