/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.nettyutil.handler.NetconfXMLToHelloMessageDecoder;
import org.w3c.dom.Document;

public class NetconfXMLToHelloMessageDecoderTest {
    @Test
    public void testDecodeWithHeader() throws Exception {
        ByteBuf src = Unpooled.wrappedBuffer((byte[])String.format("%s\n%s", "[tomas;10.0.0.0:10000;tcp;client;]", "<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>").getBytes());
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToHelloMessageDecoder().decode(null, src, (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertThat(out.get(0), (Matcher)CoreMatchers.instanceOf(NetconfHelloMessage.class));
        NetconfHelloMessage hello = (NetconfHelloMessage)out.get(0);
        Assert.assertTrue((boolean)hello.getAdditionalHeader().isPresent());
        Assert.assertEquals((Object)("[tomas;10.0.0.0:10000;tcp;client;]" + System.lineSeparator()), (Object)((NetconfHelloMessageAdditionalHeader)hello.getAdditionalHeader().get()).toFormattedString());
        Assert.assertThat((Object)XmlUtil.toString((Document)hello.getDocument()), (Matcher)CoreMatchers.containsString((String)"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\""));
    }

    @Test
    public void testDecodeNoHeader() throws Exception {
        ByteBuf src = Unpooled.wrappedBuffer((byte[])"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>".getBytes());
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToHelloMessageDecoder().decode(null, src, (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertThat(out.get(0), (Matcher)CoreMatchers.instanceOf(NetconfHelloMessage.class));
        NetconfHelloMessage hello = (NetconfHelloMessage)out.get(0);
        Assert.assertFalse((boolean)hello.getAdditionalHeader().isPresent());
    }

    @Test
    public void testDecodeCaching() throws Exception {
        ByteBuf msg1 = Unpooled.wrappedBuffer((byte[])"<rpc-reply xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>".getBytes());
        ByteBuf msg2 = Unpooled.wrappedBuffer((byte[])"<rpc-reply xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>".getBytes());
        ByteBuf src = Unpooled.wrappedBuffer((byte[])"<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>".getBytes());
        ArrayList out = Lists.newArrayList();
        NetconfXMLToHelloMessageDecoder decoder = new NetconfXMLToHelloMessageDecoder();
        decoder.decode(null, src, (List)out);
        decoder.decode(null, msg1, (List)out);
        decoder.decode(null, msg2, (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)decoder.getPostHelloNetconfMessages()));
    }

    @Test(expected=IllegalStateException.class)
    public void testDecodeNotHelloReceived() throws Exception {
        ByteBuf msg1 = Unpooled.wrappedBuffer((byte[])"<rpc-reply xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"/>".getBytes());
        ArrayList out = Lists.newArrayList();
        NetconfXMLToHelloMessageDecoder decoder = new NetconfXMLToHelloMessageDecoder();
        decoder.decode(null, msg1, (List)out);
    }
}

