/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.netconf.nettyutil.handler.NetconfXMLToMessageDecoder;
import org.xml.sax.SAXParseException;

public class NetconfXMLToMessageDecoderTest {
    @Test
    public void testDecodeNoMoreContent() throws Exception {
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToMessageDecoder().decode(null, Unpooled.buffer(), (List)out);
        Assert.assertEquals((long)0L, (long)out.size());
    }

    @Test
    public void testDecode() throws Exception {
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToMessageDecoder().decode(null, Unpooled.wrappedBuffer((byte[])"<msg/>".getBytes()), (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
    }

    @Test
    public void testDecodeWithLeadingLFAndXmlDecl() throws Exception {
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToMessageDecoder().decode(null, Unpooled.wrappedBuffer((byte[])"\n<?xml version=\"1.0\" encoding=\"UTF-8\"?><msg/>".getBytes()), (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
    }

    @Test
    public void testDecodeWithLeadingCRLFAndXmlDecl() throws Exception {
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToMessageDecoder().decode(null, Unpooled.wrappedBuffer((byte[])"\r\n<?xml version=\"1.0\" encoding=\"UTF-8\"?><msg/>".getBytes()), (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
    }

    @Test(expected=SAXParseException.class)
    public void testDecodeGibberish() throws Exception {
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToMessageDecoder().decode(null, Unpooled.wrappedBuffer((byte[])"\r\n?xml version>".getBytes()), (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
    }

    @Test
    public void testDecodeOnlyWhitespaces() throws Exception {
        ArrayList out = Lists.newArrayList();
        new NetconfXMLToMessageDecoder().decode(null, Unpooled.wrappedBuffer((byte[])"\r\n".getBytes()), (List)out);
        Assert.assertEquals((long)0L, (long)out.size());
    }

    @Test
    public void testDecodeWithAllWhitespaces() throws Exception {
        ArrayList out = Lists.newArrayList();
        byte[] whitespaces = new byte[]{32, 9, 10, 13, 12, 11};
        new NetconfXMLToMessageDecoder().decode(null, Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])whitespaces), Unpooled.wrappedBuffer((byte[])"<?xml version=\"1.0\" encoding=\"UTF-8\"?><msg/>".getBytes())}), (List)out);
        Assert.assertEquals((long)1L, (long)out.size());
    }
}

