/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.exi;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opendaylight.controller.config.util.xml.XmlElement;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.netconf.nettyutil.handler.exi.EXIParameters;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptions;
import org.w3c.dom.Element;

@RunWith(value=Parameterized.class)
public class EXIParametersTest {
    private final String sourceXml;
    private final EXIOptions exiOptions;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() throws Exception {
        String noChangeXml = "<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>bit-packed</alignment>\n</start-exi>\n";
        String fullOptionsXml = "<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>byte-aligned</alignment>\n<fidelity>\n<comments/>\n<dtd/>\n<lexical-values/>\n<pis/>\n<prefixes/>\n</fidelity>\n</start-exi>\n";
        EXIOptions fullOptions = new EXIOptions();
        fullOptions.setAlignmentType(AlignmentType.byteAligned);
        fullOptions.setPreserveLexicalValues(true);
        fullOptions.setPreserveDTD(true);
        fullOptions.setPreserveComments(true);
        fullOptions.setPreserveNS(true);
        fullOptions.setPreservePIs(true);
        return Arrays.asList({"<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>bit-packed</alignment>\n</start-exi>\n", new EXIOptions()}, {"<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>byte-aligned</alignment>\n<fidelity>\n<comments/>\n<dtd/>\n<lexical-values/>\n<pis/>\n<prefixes/>\n</fidelity>\n</start-exi>\n", fullOptions});
    }

    public EXIParametersTest(String sourceXml, EXIOptions exiOptions) {
        this.sourceXml = sourceXml;
        this.exiOptions = exiOptions;
    }

    @Test
    public void testFromXmlElement() throws Exception {
        EXIParameters opts = EXIParameters.fromXmlElement((XmlElement)XmlElement.fromDomElement((Element)XmlUtil.readXmlToElement((String)this.sourceXml)));
        Assert.assertEquals((Object)opts.getOptions().getAlignmentType(), (Object)this.exiOptions.getAlignmentType());
        Assert.assertEquals((Object)opts.getOptions().getPreserveComments(), (Object)this.exiOptions.getPreserveComments());
        Assert.assertEquals((Object)opts.getOptions().getPreserveLexicalValues(), (Object)this.exiOptions.getPreserveLexicalValues());
        Assert.assertEquals((Object)opts.getOptions().getPreserveNS(), (Object)this.exiOptions.getPreserveNS());
        Assert.assertEquals((Object)opts.getOptions().getPreserveDTD(), (Object)this.exiOptions.getPreserveDTD());
        Assert.assertEquals((Object)opts.getOptions().getPreserveNS(), (Object)this.exiOptions.getPreserveNS());
    }
}

