/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.exi;

import java.util.Arrays;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opendaylight.netconf.nettyutil.handler.exi.NetconfStartExiMessage;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptions;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class NetconfStartExiMessageTest {
    private final String controlXml;
    private final EXIOptions exiOptions;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() throws Exception {
        String noChangeXml = "<rpc xmlns:ns0=\"urn:ietf:params:xml:ns:netconf:base:1.0\" ns0:message-id=\"id\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>bit-packed</alignment>\n</start-exi>\n</rpc>";
        String fullOptionsXml = "<rpc xmlns:ns0=\"urn:ietf:params:xml:ns:netconf:base:1.0\" ns0:message-id=\"id\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>byte-aligned</alignment>\n<fidelity>\n<comments/>\n<dtd/>\n<lexical-values/>\n<pis/>\n<prefixes/>\n</fidelity>\n</start-exi>\n</rpc>";
        EXIOptions fullOptions = new EXIOptions();
        fullOptions.setAlignmentType(AlignmentType.byteAligned);
        fullOptions.setPreserveLexicalValues(true);
        fullOptions.setPreserveDTD(true);
        fullOptions.setPreserveComments(true);
        fullOptions.setPreserveNS(true);
        fullOptions.setPreservePIs(true);
        return Arrays.asList({"<rpc xmlns:ns0=\"urn:ietf:params:xml:ns:netconf:base:1.0\" ns0:message-id=\"id\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>bit-packed</alignment>\n</start-exi>\n</rpc>", new EXIOptions()}, {"<rpc xmlns:ns0=\"urn:ietf:params:xml:ns:netconf:base:1.0\" ns0:message-id=\"id\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n<start-exi xmlns=\"urn:ietf:params:xml:ns:netconf:exi:1.0\">\n<alignment>byte-aligned</alignment>\n<fidelity>\n<comments/>\n<dtd/>\n<lexical-values/>\n<pis/>\n<prefixes/>\n</fidelity>\n</start-exi>\n</rpc>", fullOptions});
    }

    public NetconfStartExiMessageTest(String controlXml, EXIOptions exiOptions) {
        this.controlXml = controlXml;
        this.exiOptions = exiOptions;
    }

    @Test
    public void testCreate() throws Exception {
        NetconfStartExiMessage startExiMessage = NetconfStartExiMessage.create((EXIOptions)this.exiOptions, (String)"id");
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        Diff diff = XMLUnit.compareXML((Document)XMLUnit.buildControlDocument((String)this.controlXml), (Document)startExiMessage.getDocument());
        Assert.assertTrue((String)diff.toString(), (boolean)diff.similar());
    }
}

