/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import java.io.IOException;
import java.net.SocketAddress;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoReadFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.WritePendingException;
import org.apache.sshd.common.util.Buffer;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandler;

public class AsyncSshHandlerTest {
    @Mock
    private SshClient sshClient;
    @Mock
    private AuthenticationHandler authHandler;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;
    @Mock
    private SocketAddress remoteAddress;
    @Mock
    private SocketAddress localAddress;
    private AsyncSshHandler asyncSshHandler;
    private SshFutureListener<ConnectFuture> sshConnectListener;
    private SshFutureListener<AuthFuture> sshAuthListener;
    private SshFutureListener<OpenFuture> sshChannelOpenListener;
    private ChannelPromise promise;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.stubAuth();
        this.stubSshClient();
        this.stubChannel();
        this.stubCtx();
        this.stubRemoteAddress();
        this.promise = this.getMockedPromise();
        this.asyncSshHandler = new AsyncSshHandler(this.authHandler, this.sshClient);
    }

    @After
    public void tearDown() throws Exception {
        this.sshConnectListener = null;
        this.sshAuthListener = null;
        this.sshChannelOpenListener = null;
        this.promise = null;
        this.asyncSshHandler.close(this.ctx, this.getMockedPromise());
    }

    private void stubAuth() throws IOException {
        ((AuthenticationHandler)Mockito.doReturn((Object)"usr").when((Object)this.authHandler)).getUsername();
        AuthFuture authFuture = (AuthFuture)Mockito.mock(AuthFuture.class);
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(authFuture), (FutureCallback)new SuccessFutureListener<AuthFuture>(){

            @Override
            public void onSuccess(SshFutureListener<AuthFuture> result) {
                AsyncSshHandlerTest.this.sshAuthListener = result;
            }
        });
        ((AuthenticationHandler)Mockito.doReturn((Object)authFuture).when((Object)this.authHandler)).authenticate((ClientSession)Matchers.any(ClientSession.class));
    }

    private static <T extends SshFuture<T>> ListenableFuture<SshFutureListener<T>> stubAddListener(T future) {
        final SettableFuture listenerSettableFuture = SettableFuture.create();
        ((SshFuture)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listenerSettableFuture.set((Object)((SshFutureListener)invocation.getArguments()[0]));
                return null;
            }
        }).when(future)).addListener((SshFutureListener)Matchers.any(SshFutureListener.class));
        return listenerSettableFuture;
    }

    private void stubRemoteAddress() {
        ((SocketAddress)Mockito.doReturn((Object)"remote").when((Object)this.remoteAddress)).toString();
    }

    private void stubCtx() {
        ((ChannelHandlerContext)Mockito.doReturn((Object)this.channel).when((Object)this.ctx)).channel();
        ((ChannelHandlerContext)Mockito.doReturn((Object)this.ctx).when((Object)this.ctx)).fireChannelActive();
        ((ChannelHandlerContext)Mockito.doReturn((Object)this.ctx).when((Object)this.ctx)).fireChannelInactive();
        ((ChannelHandlerContext)Mockito.doReturn((Object)this.ctx).when((Object)this.ctx)).fireChannelRead(Matchers.anyObject());
        ((ChannelHandlerContext)Mockito.doReturn((Object)Mockito.mock(ChannelFuture.class)).when((Object)this.ctx)).disconnect((ChannelPromise)Matchers.any(ChannelPromise.class));
        ((ChannelHandlerContext)Mockito.doReturn((Object)this.getMockedPromise()).when((Object)this.ctx)).newPromise();
    }

    private void stubChannel() {
        ((Channel)Mockito.doReturn((Object)"channel").when((Object)this.channel)).toString();
    }

    private void stubSshClient() {
        ((SshClient)Mockito.doNothing().when((Object)this.sshClient)).start();
        ConnectFuture connectFuture = (ConnectFuture)Mockito.mock(ConnectFuture.class);
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(connectFuture), (FutureCallback)new SuccessFutureListener<ConnectFuture>(){

            @Override
            public void onSuccess(SshFutureListener<ConnectFuture> result) {
                AsyncSshHandlerTest.this.sshConnectListener = result;
            }
        });
        ((SshClient)Mockito.doReturn((Object)connectFuture).when((Object)this.sshClient)).connect("usr", this.remoteAddress);
    }

    @Test
    public void testConnectSuccess() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ((ChannelSubsystem)Mockito.verify((Object)subsystemChannel)).setStreaming(ClientChannel.Streaming.Async);
        ((ChannelPromise)Mockito.verify((Object)this.promise)).setSuccess();
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).fireChannelActive();
    }

    @Test
    public void testRead() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).fireChannelRead(Matchers.any(ByteBuf.class));
    }

    @Test
    public void testReadClosed() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        final IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        final IoReadFuture mockedReadFuture = asyncOut.read(null);
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(mockedReadFuture), (FutureCallback)new SuccessFutureListener<IoReadFuture>(){

            @Override
            public void onSuccess(SshFutureListener<IoReadFuture> result) {
                ((IoReadFuture)Mockito.doReturn((Object)new IllegalStateException()).when((Object)mockedReadFuture)).getException();
                ((IoReadFuture)Mockito.doReturn((Object)mockedReadFuture).when((Object)mockedReadFuture)).removeListener((SshFutureListener)Matchers.any());
                ((IoInputStream)Mockito.doReturn((Object)true).when((Object)asyncOut)).isClosing();
                ((IoInputStream)Mockito.doReturn((Object)true).when((Object)asyncOut)).isClosed();
                result.operationComplete((SshFuture)mockedReadFuture);
            }
        });
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).fireChannelInactive();
    }

    @Test
    public void testReadFail() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        final IoReadFuture mockedReadFuture = asyncOut.read(null);
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(mockedReadFuture), (FutureCallback)new SuccessFutureListener<IoReadFuture>(){

            @Override
            public void onSuccess(SshFutureListener<IoReadFuture> result) {
                ((IoReadFuture)Mockito.doReturn((Object)new IllegalStateException()).when((Object)mockedReadFuture)).getException();
                ((IoReadFuture)Mockito.doReturn((Object)mockedReadFuture).when((Object)mockedReadFuture)).removeListener((SshFutureListener)Matchers.any());
                result.operationComplete((SshFuture)mockedReadFuture);
            }
        });
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).fireChannelInactive();
    }

    @Test
    public void testWrite() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ChannelPromise writePromise = this.getMockedPromise();
        this.asyncSshHandler.write(this.ctx, (Object)Unpooled.copiedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5}), writePromise);
        ((ChannelPromise)Mockito.verify((Object)writePromise)).setSuccess();
    }

    @Test
    public void testWriteClosed() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        final IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        final IoWriteFuture ioWriteFuture = asyncIn.write(null);
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(ioWriteFuture), (FutureCallback)new SuccessFutureListener<IoWriteFuture>(){

            @Override
            public void onSuccess(SshFutureListener<IoWriteFuture> result) {
                ((IoWriteFuture)Mockito.doReturn((Object)false).when((Object)ioWriteFuture)).isWritten();
                ((IoWriteFuture)Mockito.doReturn((Object)new IllegalStateException()).when((Object)ioWriteFuture)).getException();
                ((IoOutputStream)Mockito.doReturn((Object)true).when((Object)asyncIn)).isClosing();
                ((IoOutputStream)Mockito.doReturn((Object)true).when((Object)asyncIn)).isClosed();
                result.operationComplete((SshFuture)ioWriteFuture);
            }
        });
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ChannelPromise writePromise = this.getMockedPromise();
        this.asyncSshHandler.write(this.ctx, (Object)Unpooled.copiedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5}), writePromise);
        ((ChannelPromise)Mockito.verify((Object)writePromise)).setFailure((Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testWritePendingOne() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        IoWriteFuture ioWriteFuture = asyncIn.write(null);
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ChannelPromise firstWritePromise = this.getMockedPromise();
        ListenableFuture<SshFutureListener<IoWriteFuture>> firstWriteListenerFuture = AsyncSshHandlerTest.stubAddListener(ioWriteFuture);
        this.asyncSshHandler.write(this.ctx, (Object)Unpooled.copiedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5}), firstWritePromise);
        SshFutureListener firstWriteListener = (SshFutureListener)firstWriteListenerFuture.get();
        ListenableFuture<SshFutureListener<IoWriteFuture>> pendingListener = AsyncSshHandlerTest.stubAddListener(ioWriteFuture);
        ChannelPromise secondWritePromise = this.getMockedPromise();
        ((IoOutputStream)Mockito.doThrow(WritePendingException.class).when((Object)asyncIn)).write((Buffer)Matchers.any(Buffer.class));
        this.asyncSshHandler.write(this.ctx, (Object)Unpooled.copiedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5}), secondWritePromise);
        ((IoOutputStream)Mockito.doReturn((Object)ioWriteFuture).when((Object)asyncIn)).write((Buffer)Matchers.any(Buffer.class));
        Mockito.verifyZeroInteractions((Object[])new Object[]{firstWritePromise, secondWritePromise});
        firstWriteListener.operationComplete((SshFuture)ioWriteFuture);
        ((SshFutureListener)pendingListener.get()).operationComplete((SshFuture)ioWriteFuture);
        ((ChannelPromise)Mockito.verify((Object)firstWritePromise)).setSuccess();
        ((ChannelPromise)Mockito.verify((Object)secondWritePromise)).setSuccess();
    }

    @Ignore(value="Pending queue is not limited")
    @Test
    public void testWritePendingMax() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        IoWriteFuture ioWriteFuture = asyncIn.write(null);
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ChannelPromise firstWritePromise = this.getMockedPromise();
        ListenableFuture<SshFutureListener<IoWriteFuture>> firstWriteListenerFuture = AsyncSshHandlerTest.stubAddListener(ioWriteFuture);
        this.asyncSshHandler.write(this.ctx, (Object)Unpooled.copiedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5}), firstWritePromise);
        ChannelPromise secondWritePromise = this.getMockedPromise();
        ((IoOutputStream)Mockito.doThrow(WritePendingException.class).when((Object)asyncIn)).write((Buffer)Matchers.any(Buffer.class));
        for (int i = 0; i < 1001; ++i) {
            this.asyncSshHandler.write(this.ctx, (Object)Unpooled.copiedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5}), secondWritePromise);
        }
        ((ChannelPromise)Mockito.verify((Object)secondWritePromise, (VerificationMode)Mockito.times((int)1))).setFailure((Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testDisconnect() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessOpenFuture());
        ChannelPromise disconnectPromise = this.getMockedPromise();
        this.asyncSshHandler.disconnect(this.ctx, disconnectPromise);
        ((ClientSession)Mockito.verify((Object)sshSession)).close(Matchers.anyBoolean());
        ((ChannelPromise)Mockito.verify((Object)disconnectPromise)).setSuccess();
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).fireChannelInactive();
    }

    private static OpenFuture getSuccessOpenFuture() {
        OpenFuture failedOpenFuture = (OpenFuture)Mockito.mock(OpenFuture.class);
        ((OpenFuture)Mockito.doReturn((Object)true).when((Object)failedOpenFuture)).isOpened();
        return failedOpenFuture;
    }

    private static AuthFuture getSuccessAuthFuture() {
        AuthFuture authFuture = (AuthFuture)Mockito.mock(AuthFuture.class);
        ((AuthFuture)Mockito.doReturn((Object)true).when((Object)authFuture)).isSuccess();
        return authFuture;
    }

    private static ConnectFuture getSuccessConnectFuture(ClientSession sshSession) {
        ConnectFuture connectFuture = (ConnectFuture)Mockito.mock(ConnectFuture.class);
        ((ConnectFuture)Mockito.doReturn((Object)true).when((Object)connectFuture)).isConnected();
        ((ConnectFuture)Mockito.doReturn((Object)sshSession).when((Object)connectFuture)).getSession();
        return connectFuture;
    }

    private static ClientSession getMockedSshSession(ChannelSubsystem subsystemChannel) throws IOException {
        ClientSession sshSession = (ClientSession)Mockito.mock(ClientSession.class);
        ((ClientSession)Mockito.doReturn((Object)"sshSession").when((Object)sshSession)).toString();
        ((ClientSession)Mockito.doReturn((Object)"serverVersion").when((Object)sshSession)).getServerVersion();
        ((ClientSession)Mockito.doReturn((Object)false).when((Object)sshSession)).isClosed();
        ((ClientSession)Mockito.doReturn((Object)false).when((Object)sshSession)).isClosing();
        final CloseFuture closeFuture = (CloseFuture)Mockito.mock(CloseFuture.class);
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(closeFuture), (FutureCallback)new SuccessFutureListener<CloseFuture>(){

            @Override
            public void onSuccess(SshFutureListener<CloseFuture> result) {
                ((CloseFuture)Mockito.doReturn((Object)true).when((Object)closeFuture)).isClosed();
                result.operationComplete((SshFuture)closeFuture);
            }
        });
        ((ClientSession)Mockito.doReturn((Object)closeFuture).when((Object)sshSession)).close(false);
        ((ClientSession)Mockito.doReturn((Object)subsystemChannel).when((Object)sshSession)).createSubsystemChannel(Matchers.anyString());
        return sshSession;
    }

    private ChannelSubsystem getMockedSubsystemChannel(IoInputStream asyncOut, IoOutputStream asyncIn) throws IOException {
        ChannelSubsystem subsystemChannel = (ChannelSubsystem)Mockito.mock(ChannelSubsystem.class);
        ((ChannelSubsystem)Mockito.doReturn((Object)"subsystemChannel").when((Object)subsystemChannel)).toString();
        ((ChannelSubsystem)Mockito.doNothing().when((Object)subsystemChannel)).setStreaming((ClientChannel.Streaming)Matchers.any(ClientChannel.Streaming.class));
        OpenFuture openFuture = (OpenFuture)Mockito.mock(OpenFuture.class);
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(openFuture), (FutureCallback)new SuccessFutureListener<OpenFuture>(){

            @Override
            public void onSuccess(SshFutureListener<OpenFuture> result) {
                AsyncSshHandlerTest.this.sshChannelOpenListener = result;
            }
        });
        ((ChannelSubsystem)Mockito.doReturn((Object)asyncOut).when((Object)subsystemChannel)).getAsyncOut();
        ((ChannelSubsystem)Mockito.doReturn((Object)openFuture).when((Object)subsystemChannel)).open();
        ((ChannelSubsystem)Mockito.doReturn((Object)asyncIn).when((Object)subsystemChannel)).getAsyncIn();
        return subsystemChannel;
    }

    private static IoOutputStream getMockedIoOutputStream() {
        IoOutputStream mock = (IoOutputStream)Mockito.mock(IoOutputStream.class);
        final IoWriteFuture ioWriteFuture = (IoWriteFuture)Mockito.mock(IoWriteFuture.class);
        ((IoWriteFuture)Mockito.doReturn((Object)ioWriteFuture).when((Object)ioWriteFuture)).addListener((SshFutureListener)Matchers.any());
        ((IoWriteFuture)Mockito.doReturn((Object)true).when((Object)ioWriteFuture)).isWritten();
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(ioWriteFuture), (FutureCallback)new SuccessFutureListener<IoWriteFuture>(){

            @Override
            public void onSuccess(SshFutureListener<IoWriteFuture> result) {
                result.operationComplete((SshFuture)ioWriteFuture);
            }
        });
        ((IoOutputStream)Mockito.doReturn((Object)ioWriteFuture).when((Object)mock)).write((Buffer)Matchers.any(Buffer.class));
        ((IoOutputStream)Mockito.doReturn((Object)false).when((Object)mock)).isClosed();
        ((IoOutputStream)Mockito.doReturn((Object)false).when((Object)mock)).isClosing();
        return mock;
    }

    private static IoInputStream getMockedIoInputStream() {
        IoInputStream mock = (IoInputStream)Mockito.mock(IoInputStream.class);
        final IoReadFuture ioReadFuture = (IoReadFuture)Mockito.mock(IoReadFuture.class);
        ((IoReadFuture)Mockito.doReturn(null).when((Object)ioReadFuture)).getException();
        ((IoReadFuture)Mockito.doReturn((Object)ioReadFuture).when((Object)ioReadFuture)).removeListener((SshFutureListener)Matchers.any());
        ((IoReadFuture)Mockito.doReturn((Object)5).when((Object)ioReadFuture)).getRead();
        ((IoReadFuture)Mockito.doReturn((Object)new Buffer(new byte[]{0, 1, 2, 3, 4})).when((Object)ioReadFuture)).getBuffer();
        ((IoReadFuture)Mockito.doReturn((Object)ioReadFuture).when((Object)ioReadFuture)).addListener((SshFutureListener)Matchers.any());
        Futures.addCallback(AsyncSshHandlerTest.stubAddListener(ioReadFuture), (FutureCallback)new SuccessFutureListener<IoReadFuture>(){

            @Override
            public void onSuccess(SshFutureListener<IoReadFuture> result) {
                result.operationComplete((SshFuture)ioReadFuture);
            }
        });
        ((IoInputStream)Mockito.doReturn((Object)ioReadFuture).when((Object)mock)).read((Buffer)Matchers.any(Buffer.class));
        ((IoInputStream)Mockito.doReturn((Object)false).when((Object)mock)).isClosed();
        ((IoInputStream)Mockito.doReturn((Object)false).when((Object)mock)).isClosing();
        return mock;
    }

    @Test
    public void testConnectFailOpenChannel() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        IoInputStream asyncOut = AsyncSshHandlerTest.getMockedIoInputStream();
        IoOutputStream asyncIn = AsyncSshHandlerTest.getMockedIoOutputStream();
        ChannelSubsystem subsystemChannel = this.getMockedSubsystemChannel(asyncOut, asyncIn);
        ClientSession sshSession = AsyncSshHandlerTest.getMockedSshSession(subsystemChannel);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        this.sshAuthListener.operationComplete((SshFuture)AsyncSshHandlerTest.getSuccessAuthFuture());
        ((ChannelSubsystem)Mockito.verify((Object)subsystemChannel)).setStreaming(ClientChannel.Streaming.Async);
        this.sshChannelOpenListener.operationComplete((SshFuture)AsyncSshHandlerTest.getFailedOpenFuture());
        ((ChannelPromise)Mockito.verify((Object)this.promise)).setFailure((Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testConnectFailAuth() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        ClientSession sshSession = (ClientSession)Mockito.mock(ClientSession.class);
        ((ClientSession)Mockito.doReturn((Object)true).when((Object)sshSession)).isClosed();
        ConnectFuture connectFuture = AsyncSshHandlerTest.getSuccessConnectFuture(sshSession);
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        AuthFuture authFuture = AsyncSshHandlerTest.getFailedAuthFuture();
        this.sshAuthListener.operationComplete((SshFuture)authFuture);
        ((ChannelPromise)Mockito.verify((Object)this.promise)).setFailure((Throwable)Matchers.any(Throwable.class));
    }

    private static AuthFuture getFailedAuthFuture() {
        AuthFuture authFuture = (AuthFuture)Mockito.mock(AuthFuture.class);
        ((AuthFuture)Mockito.doReturn((Object)false).when((Object)authFuture)).isSuccess();
        ((AuthFuture)Mockito.doReturn((Object)new IllegalStateException()).when((Object)authFuture)).getException();
        return authFuture;
    }

    private static OpenFuture getFailedOpenFuture() {
        OpenFuture authFuture = (OpenFuture)Mockito.mock(OpenFuture.class);
        ((OpenFuture)Mockito.doReturn((Object)false).when((Object)authFuture)).isOpened();
        ((OpenFuture)Mockito.doReturn((Object)new IllegalStateException()).when((Object)authFuture)).getException();
        return authFuture;
    }

    @Test
    public void testConnectFail() throws Exception {
        this.asyncSshHandler.connect(this.ctx, this.remoteAddress, this.localAddress, this.promise);
        ConnectFuture connectFuture = AsyncSshHandlerTest.getFailedConnectFuture();
        this.sshConnectListener.operationComplete((SshFuture)connectFuture);
        ((ChannelPromise)Mockito.verify((Object)this.promise)).setFailure((Throwable)Matchers.any(Throwable.class));
    }

    private static ConnectFuture getFailedConnectFuture() {
        ConnectFuture connectFuture = (ConnectFuture)Mockito.mock(ConnectFuture.class);
        ((ConnectFuture)Mockito.doReturn((Object)false).when((Object)connectFuture)).isConnected();
        ((ConnectFuture)Mockito.doReturn((Object)new IllegalStateException()).when((Object)connectFuture)).getException();
        return connectFuture;
    }

    private ChannelPromise getMockedPromise() {
        return (ChannelPromise)Mockito.spy((Object)new DefaultChannelPromise(this.channel));
    }

    private static abstract class SuccessFutureListener<T extends SshFuture<T>>
    implements FutureCallback<SshFutureListener<T>> {
        private SuccessFutureListener() {
        }

        public abstract void onSuccess(SshFutureListener<T> var1);

        public void onFailure(Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

