/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfChunkAggregator
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfChunkAggregator.class);
    private static final String GOT_PARAM_WHILE_WAITING_FOR_PARAM = "Got byte {} while waiting for {}";
    private static final String GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM = "Got byte {} while waiting for {}-{}";
    public static final int DEFAULT_MAXIMUM_CHUNK_SIZE = 0x1000000;
    private final int maxChunkSize = 0x1000000;
    private State state = State.HEADER_ONE;
    private long chunkSize;
    private CompositeByteBuf chunk;

    private static void checkNewLine(byte b, String errorMessage) {
        if (b != 10) {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM, (Object)b, (Object)10);
            throw new IllegalStateException(errorMessage);
        }
    }

    private static void checkHash(byte b, String errorMessage) {
        if (b != 35) {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM, (Object)b, (Object)35);
            throw new IllegalStateException(errorMessage);
        }
    }

    private void checkChunkSize() {
        if (this.chunkSize > 0x1000000L) {
            LOG.debug("Parsed chunk size {}, maximum allowed is {}", (Object)this.chunkSize, (Object)0x1000000);
            throw new IllegalStateException("Maximum chunk size exceeded");
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IllegalStateException {
        while (in.isReadable()) {
            switch (this.state) {
                case HEADER_ONE: {
                    byte b = in.readByte();
                    NetconfChunkAggregator.checkNewLine(b, "Malformed chunk header encountered (byte 0)");
                    this.state = State.HEADER_TWO;
                    this.initChunk();
                    break;
                }
                case HEADER_TWO: {
                    byte b = in.readByte();
                    NetconfChunkAggregator.checkHash(b, "Malformed chunk header encountered (byte 1)");
                    this.state = State.HEADER_LENGTH_FIRST;
                    break;
                }
                case HEADER_LENGTH_FIRST: {
                    byte b = in.readByte();
                    this.chunkSize = NetconfChunkAggregator.processHeaderLengthFirst(b);
                    this.state = State.HEADER_LENGTH_OTHER;
                    break;
                }
                case HEADER_LENGTH_OTHER: {
                    byte b = in.readByte();
                    if (b == 10) {
                        this.state = State.DATA;
                        break;
                    }
                    if (b < 48 || b > 57) {
                        LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM, new Object[]{b, (byte)48, (byte)57});
                        throw new IllegalStateException("Invalid chunk size encountered");
                    }
                    this.chunkSize *= 10L;
                    this.chunkSize += (long)(b - 48);
                    this.checkChunkSize();
                    break;
                }
                case DATA: {
                    if ((long)in.readableBytes() < this.chunkSize) {
                        LOG.debug("Buffer has {} bytes, need {} to complete chunk", (Object)in.readableBytes(), (Object)this.chunkSize);
                        in.discardReadBytes();
                        return;
                    }
                    this.aggregateChunks(in.readBytes((int)this.chunkSize));
                    this.state = State.FOOTER_ONE;
                    break;
                }
                case FOOTER_ONE: {
                    byte b = in.readByte();
                    NetconfChunkAggregator.checkNewLine(b, "Malformed chunk footer encountered (byte 0)");
                    this.state = State.FOOTER_TWO;
                    this.chunkSize = 0L;
                    break;
                }
                case FOOTER_TWO: {
                    byte b = in.readByte();
                    NetconfChunkAggregator.checkHash(b, "Malformed chunk footer encountered (byte 1)");
                    this.state = State.FOOTER_THREE;
                    break;
                }
                case FOOTER_THREE: {
                    byte b = in.readByte();
                    this.extractNewChunkOrMessageEnd(b);
                    break;
                }
                case FOOTER_FOUR: {
                    byte b = in.readByte();
                    NetconfChunkAggregator.checkNewLine(b, "Malformed chunk footer encountered (byte 3)");
                    this.state = State.HEADER_ONE;
                    out.add(this.chunk);
                    this.chunk = null;
                    break;
                }
            }
        }
        in.discardReadBytes();
    }

    private void extractNewChunkOrMessageEnd(byte b) {
        if (NetconfChunkAggregator.isHeaderLengthFirst(b)) {
            this.chunkSize = NetconfChunkAggregator.processHeaderLengthFirst(b);
            this.state = State.HEADER_LENGTH_OTHER;
        } else if (b == 35) {
            this.state = State.FOOTER_FOUR;
        } else {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM, new Object[]{b, (byte)35, (byte)49, (byte)57});
            throw new IllegalStateException("Malformed chunk footer encountered (byte 2)");
        }
    }

    private void initChunk() {
        this.chunk = Unpooled.compositeBuffer();
    }

    private void aggregateChunks(ByteBuf newChunk) {
        this.chunk.addComponent(this.chunk.numComponents(), newChunk);
        this.chunk.writerIndex(this.chunk.writerIndex() + newChunk.readableBytes());
    }

    private static int processHeaderLengthFirst(byte b) {
        if (!NetconfChunkAggregator.isHeaderLengthFirst(b)) {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM, new Object[]{b, (byte)49, (byte)57});
            throw new IllegalStateException("Invalid chunk size encountered (byte 0)");
        }
        return b - 48;
    }

    private static boolean isHeaderLengthFirst(byte b) {
        return b >= 49 && b <= 57;
    }

    private static enum State {
        HEADER_ONE,
        HEADER_TWO,
        HEADER_LENGTH_FIRST,
        HEADER_LENGTH_OTHER,
        DATA,
        FOOTER_ONE,
        FOOTER_TWO,
        FOOTER_THREE,
        FOOTER_FOUR;

    }
}

