/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.netconf.api.FailedNetconfMessage;
import org.opendaylight.netconf.api.NetconfMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class NetconfXMLToMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfXMLToMessageDecoder.class);

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException, SAXException {
        if (in.isReadable()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
            }
            while (in.isReadable()) {
                if (NetconfXMLToMessageDecoder.isWhitespace(in.readByte())) continue;
                in.readerIndex(in.readerIndex() - 1);
                break;
            }
            if (in.readerIndex() != 0 && LOG.isWarnEnabled()) {
                byte[] strippedBytes = new byte[in.readerIndex()];
                in.getBytes(0, strippedBytes, 0, in.readerIndex());
                LOG.warn("XML message with unwanted leading bytes detected. Discarded the {} leading byte(s): '{}'", (Object)in.readerIndex(), (Object)ByteBufUtil.hexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])strippedBytes)));
            }
        }
        if (in.isReadable()) {
            NetconfMessage msg;
            try {
                msg = new NetconfMessage(XmlUtil.readXmlToDocument((InputStream)new ByteBufInputStream(in)));
            }
            catch (SAXParseException exception) {
                LOG.error("Failed to parse received message", (Throwable)exception);
                msg = new FailedNetconfMessage((Throwable)exception);
            }
            out.add(msg);
        } else {
            LOG.debug("No more content in incoming buffer.");
        }
    }

    private static boolean isWhitespace(byte b) {
        return b <= 13 && b >= 9 || b == 32;
    }
}

