/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;

final class ThreadLocalTransformers {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private static final ThreadLocal<Transformer> DEFAULT_TRANSFORMER = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            return ThreadLocalTransformers.createTransformer();
        }

        @Override
        public void set(Transformer value) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<Transformer> PRETTY_TRANSFORMER = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            Transformer ret = ThreadLocalTransformers.createTransformer();
            ret.setOutputProperty("indent", "yes");
            ret.setOutputProperty("omit-xml-declaration", "no");
            return ret;
        }

        @Override
        public void set(Transformer value) {
            throw new UnsupportedOperationException();
        }
    };

    private ThreadLocalTransformers() {
        throw new UnsupportedOperationException("Utility class");
    }

    static Transformer getDefaultTransformer() {
        return DEFAULT_TRANSFORMER.get();
    }

    static Transformer getPrettyTransformer() {
        return PRETTY_TRANSFORMER.get();
    }

    private static Transformer createTransformer() {
        try {
            return FACTORY.newTransformer();
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            throw new IllegalStateException("Unexpected error while instantiating a Transformer", e);
        }
    }
}

