/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.authentication;

import java.io.IOException;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.future.AuthFuture;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;

public class LoginPassword
extends AuthenticationHandler {
    protected final String username;
    protected final String password;
    protected final AAAEncryptionService encryptionService;

    public LoginPassword(String username, String password) {
        this(username, password, null);
    }

    public LoginPassword(String username, String password, AAAEncryptionService encryptionService) {
        this.username = username;
        this.password = password;
        this.encryptionService = encryptionService;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public AuthFuture authenticate(ClientSession session) throws IOException {
        if (this.encryptionService != null) {
            String decryptedPassword = this.encryptionService.decrypt(this.password);
            session.addPasswordIdentity(decryptedPassword);
        } else {
            session.addPasswordIdentity(this.password);
        }
        return session.auth();
    }
}

