/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.authentication;

import com.google.common.base.Strings;
import java.io.IOException;
import java.security.KeyPair;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.future.AuthFuture;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.aaa.encrypt.PKIUtil;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.LoginPassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyAuth
extends LoginPassword {
    private KeyPair keyPair = null;
    private static final Logger LOG = LoggerFactory.getLogger(PublicKeyAuth.class);

    public PublicKeyAuth(String username, String password, String keyPath, String passPhrase, AAAEncryptionService encryptionService) {
        super(username, password, encryptionService);
        try {
            boolean isKeyPathAbsent = Strings.isNullOrEmpty((String)keyPath);
            String string = passPhrase = Strings.isNullOrEmpty((String)passPhrase) ? "" : passPhrase;
            if (!isKeyPathAbsent) {
                this.keyPair = new PKIUtil().decodePrivateKey(keyPath, passPhrase);
            } else {
                LOG.info("Private key path not specified in the config file.");
            }
        }
        catch (IOException ioEx) {
            LOG.warn("Not able to read the private key and passphrase for netconf client", (Throwable)ioEx);
        }
    }

    @Override
    public AuthFuture authenticate(ClientSession session) throws IOException {
        if (this.keyPair != null) {
            session.addPublicKeyIdentity(this.keyPair);
        }
        return super.authenticate(session);
    }
}

