/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.client;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerReader;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSshHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncSshHandler.class);
    public static final String SUBSYSTEM = "netconf";
    public static final int SSH_DEFAULT_NIO_WORKERS = 8;
    private static final long DEFAULT_TIMEOUT = -1L;
    public static final SshClient DEFAULT_CLIENT;
    private final AuthenticationHandler authenticationHandler;
    private final SshClient sshClient;
    private Future<?> negotiationFuture;
    private AsyncSshHandlerReader sshReadAsyncListener;
    private AsyncSshHandlerWriter sshWriteAsyncHandler;
    private ClientChannel channel;
    private ClientSession session;
    private ChannelPromise connectPromise;
    private GenericFutureListener negotiationFutureListener;

    public AsyncSshHandler(AuthenticationHandler authenticationHandler, SshClient sshClient, Future<?> negotiationFuture) throws IOException {
        this(authenticationHandler, sshClient);
        this.negotiationFuture = negotiationFuture;
    }

    public AsyncSshHandler(AuthenticationHandler authenticationHandler, SshClient sshClient) throws IOException {
        this.authenticationHandler = (AuthenticationHandler)Preconditions.checkNotNull((Object)authenticationHandler);
        this.sshClient = (SshClient)Preconditions.checkNotNull((Object)sshClient);
    }

    public static AsyncSshHandler createForNetconfSubsystem(AuthenticationHandler authenticationHandler) throws IOException {
        return new AsyncSshHandler(authenticationHandler, DEFAULT_CLIENT);
    }

    public static AsyncSshHandler createForNetconfSubsystem(AuthenticationHandler authenticationHandler, Future<?> negotiationFuture) throws IOException {
        return new AsyncSshHandler(authenticationHandler, DEFAULT_CLIENT, negotiationFuture);
    }

    private void startSsh(final ChannelHandlerContext ctx, SocketAddress address) {
        LOG.debug("Starting SSH to {} on channel: {}", (Object)address, (Object)ctx.channel());
        ConnectFuture sshConnectionFuture = this.sshClient.connect(this.authenticationHandler.getUsername(), address);
        sshConnectionFuture.addListener((SshFutureListener)new SshFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                if (future.isConnected()) {
                    AsyncSshHandler.this.handleSshSessionCreated(future, ctx);
                } else {
                    AsyncSshHandler.this.handleSshSetupFailure(ctx, future.getException());
                }
            }
        });
    }

    private synchronized void handleSshSessionCreated(ConnectFuture future, final ChannelHandlerContext ctx) {
        try {
            LOG.trace("SSH session created on channel: {}", (Object)ctx.channel());
            this.session = future.getSession();
            AuthFuture authenticateFuture = this.authenticationHandler.authenticate(this.session);
            authenticateFuture.addListener((SshFutureListener)new SshFutureListener<AuthFuture>(){

                public void operationComplete(AuthFuture future) {
                    if (future.isSuccess()) {
                        AsyncSshHandler.this.handleSshAuthenticated(AsyncSshHandler.this.session, ctx);
                    } else {
                        Throwable exception = future.getException() == null ? new IllegalStateException("Authentication failed") : future.getException();
                        AsyncSshHandler.this.handleSshSetupFailure(ctx, exception);
                    }
                }
            });
        }
        catch (IOException e) {
            this.handleSshSetupFailure(ctx, e);
        }
    }

    private synchronized void handleSshAuthenticated(ClientSession session, final ChannelHandlerContext ctx) {
        try {
            LOG.debug("SSH session authenticated on channel: {}, server version: {}", (Object)ctx.channel(), (Object)session.getServerVersion());
            this.channel = session.createSubsystemChannel(SUBSYSTEM);
            this.channel.setStreaming(ClientChannel.Streaming.Async);
            this.channel.open().addListener((SshFutureListener)new SshFutureListener<OpenFuture>(){

                public void operationComplete(OpenFuture future) {
                    if (future.isOpened()) {
                        AsyncSshHandler.this.handleSshChanelOpened(ctx);
                    } else {
                        AsyncSshHandler.this.handleSshSetupFailure(ctx, future.getException());
                    }
                }
            });
        }
        catch (IOException e) {
            this.handleSshSetupFailure(ctx, e);
        }
    }

    private synchronized void handleSshChanelOpened(final ChannelHandlerContext ctx) {
        LOG.trace("SSH subsystem channel opened successfully on channel: {}", (Object)ctx.channel());
        if (this.negotiationFuture == null) {
            this.connectPromise.setSuccess();
        }
        this.sshReadAsyncListener = new AsyncSshHandlerReader(new AutoCloseable(){

            @Override
            public void close() throws Exception {
                AsyncSshHandler.this.disconnect(ctx, ctx.newPromise());
            }
        }, new AsyncSshHandlerReader.ReadMsgHandler(){

            @Override
            public void onMessageRead(ByteBuf msg) {
                ctx.fireChannelRead((Object)msg);
            }
        }, this.channel.toString(), this.channel.getAsyncOut());
        if (this.channel != null) {
            this.sshWriteAsyncHandler = new AsyncSshHandlerWriter(this.channel.getAsyncIn());
            ctx.fireChannelActive();
        }
    }

    private synchronized void handleSshSetupFailure(ChannelHandlerContext ctx, Throwable e) {
        LOG.warn("Unable to setup SSH connection on channel: {}", (Object)ctx.channel(), (Object)e);
        if (!this.connectPromise.isDone()) {
            this.connectPromise.setFailure(e);
        }
        this.disconnect(ctx, ctx.newPromise());
    }

    public synchronized void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.sshWriteAsyncHandler.write(ctx, msg, promise);
    }

    public synchronized void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        LOG.debug("SSH session connecting on channel {}. promise: {} ", (Object)ctx.channel(), (Object)this.connectPromise);
        this.connectPromise = promise;
        if (this.negotiationFuture != null) {
            this.negotiationFutureListener = new GenericFutureListener<Future<?>>(){

                public void operationComplete(Future<?> future) {
                    if (future.isSuccess()) {
                        AsyncSshHandler.this.connectPromise.setSuccess();
                    }
                }
            };
            this.negotiationFuture.addListener(this.negotiationFutureListener);
        }
        this.startSsh(ctx, remoteAddress);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.disconnect(ctx, promise);
    }

    public synchronized void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        LOG.trace("Closing SSH session on channel: {} with connect promise in state: {}", (Object)ctx.channel(), (Object)this.connectPromise);
        if (this.connectPromise.isSuccess()) {
            ctx.fireChannelInactive();
        }
        if (this.sshWriteAsyncHandler != null) {
            this.sshWriteAsyncHandler.close();
        }
        if (this.sshReadAsyncListener != null) {
            this.sshReadAsyncListener.close();
        }
        if (!this.connectPromise.isDone()) {
            this.connectPromise.setFailure((Throwable)new IllegalStateException("Negotiation failed"));
        }
        if (this.negotiationFuture != null) {
            this.negotiationFuture.removeListener(this.negotiationFutureListener);
        }
        if (this.session != null && !this.session.isClosed() && !this.session.isClosing()) {
            this.session.close(false).addListener((SshFutureListener)new SshFutureListener<CloseFuture>(){

                public void operationComplete(CloseFuture future) {
                    if (!future.isClosed()) {
                        AsyncSshHandler.this.session.close(true);
                    }
                    AsyncSshHandler.this.session = null;
                }
            });
        }
        try {
            super.disconnect(ctx, ctx.newPromise());
        }
        catch (Exception e) {
            LOG.warn("Unable to cleanup all resources for channel: {}. Ignoring.", (Object)ctx.channel(), (Object)e);
        }
        this.channel = null;
        promise.setSuccess();
        LOG.debug("SSH session closed on channel: {}", (Object)ctx.channel());
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("auth-timeout", Long.toString(-1L));
        props.put("idle-timeout", Long.toString(-1L));
        SshClient c = SshClient.setUpDefaultClient();
        c.setProperties(props);
        c.setNioWorkers(8);
        c.start();
        DEFAULT_CLIENT = c;
    }
}

