/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.client;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.WritePendingException;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncSshHandlerWriter
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncSshHandlerWriter.class);
    private volatile IoOutputStream asyncIn;
    private final Deque<PendingWriteRequest> pending = new LinkedList<PendingWriteRequest>();

    public AsyncSshHandlerWriter(IoOutputStream asyncIn) {
        this.asyncIn = asyncIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.asyncIn == null) {
            promise.setFailure((Throwable)new IllegalStateException("Channel closed"));
            return;
        }
        IoOutputStream ioOutputStream = this.asyncIn;
        synchronized (ioOutputStream) {
            if (this.asyncIn.isClosed() || this.asyncIn.isClosing()) {
                promise.setFailure((Throwable)new IllegalStateException("Channel closed"));
            } else {
                ByteBuf byteBufMsg = (ByteBuf)msg;
                if (!this.pending.isEmpty()) {
                    this.queueRequest(ctx, byteBufMsg, promise);
                    return;
                }
                this.writeWithPendingDetection(ctx, promise, byteBufMsg, false);
            }
        }
    }

    private void writeWithPendingDetection(final ChannelHandlerContext ctx, final ChannelPromise promise, final ByteBuf byteBufMsg, final boolean wasPending) {
        block3: {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Writing request on channel: {}, message: {}", (Object)ctx.channel(), (Object)AsyncSshHandlerWriter.byteBufToString(byteBufMsg));
                }
                this.asyncIn.write(AsyncSshHandlerWriter.toBuffer(byteBufMsg)).addListener((SshFutureListener)new SshFutureListener<IoWriteFuture>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(IoWriteFuture future) {
                        IoOutputStream ioOutputStream = AsyncSshHandlerWriter.this.asyncIn;
                        synchronized (ioOutputStream) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Ssh write request finished on channel: {} with result: {}: and ex:{}, message: {}", new Object[]{ctx.channel(), future.isWritten(), future.getException(), AsyncSshHandlerWriter.byteBufToString(byteBufMsg)});
                            }
                            if (future.isWritten()) {
                                promise.setSuccess();
                            } else {
                                LOG.warn("Ssh write request failed on channel: {} for message: {}", new Object[]{ctx.channel(), AsyncSshHandlerWriter.byteBufToString(byteBufMsg), future.getException()});
                                promise.setFailure(future.getException());
                            }
                            byteBufMsg.release();
                            if (wasPending) {
                                byteBufMsg.resetReaderIndex();
                                AsyncSshHandlerWriter.this.pending.remove();
                            }
                        }
                        AsyncSshHandlerWriter.this.writePendingIfAny();
                    }
                });
            }
            catch (WritePendingException e) {
                if (wasPending) break block3;
                this.queueRequest(ctx, byteBufMsg, promise);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePendingIfAny() {
        IoOutputStream ioOutputStream = this.asyncIn;
        synchronized (ioOutputStream) {
            if (this.pending.peek() == null) {
                return;
            }
            PendingWriteRequest pendingWrite = this.pending.peek();
            ByteBuf msg = pendingWrite.msg;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Writing pending request on channel: {}, message: {}", (Object)pendingWrite.ctx.channel(), (Object)AsyncSshHandlerWriter.byteBufToString(msg));
            }
            this.writeWithPendingDetection(pendingWrite.ctx, pendingWrite.promise, msg, true);
        }
    }

    public static String byteBufToString(ByteBuf msg) {
        String s = msg.toString(StandardCharsets.UTF_8);
        msg.resetReaderIndex();
        return s;
    }

    private void queueRequest(ChannelHandlerContext ctx, ByteBuf msg, ChannelPromise promise) {
        LOG.debug("Write pending on channel: {}, queueing, current queue size: {}", (Object)ctx.channel(), (Object)this.pending.size());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Queueing request due to pending: {}", (Object)AsyncSshHandlerWriter.byteBufToString(msg));
        }
        new PendingWriteRequest(ctx, msg, promise).pend(this.pending);
    }

    @Override
    public void close() {
        this.asyncIn = null;
    }

    private static Buffer toBuffer(ByteBuf msg) {
        msg.resetReaderIndex();
        byte[] temp = new byte[msg.readableBytes()];
        msg.readBytes(temp, 0, msg.readableBytes());
        return new Buffer(temp);
    }

    private static final class PendingWriteRequest {
        private final ChannelHandlerContext ctx;
        private final ByteBuf msg;
        private final ChannelPromise promise;

        public PendingWriteRequest(ChannelHandlerContext ctx, ByteBuf msg, ChannelPromise promise) {
            this.ctx = ctx;
            msg.resetReaderIndex();
            this.msg = msg;
            this.promise = promise;
        }

        public void pend(Queue<PendingWriteRequest> pending) {
            Preconditions.checkState((boolean)pending.offer(this), (String)"Cannot pend another request write (pending count: %s) on channel: %s", (Object[])new Object[]{pending.size(), this.ctx.channel()});
        }
    }
}

