/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.opendaylight.netconf.nettyutil.handler.FramingMechanismEncoder;
import org.opendaylight.netconf.nettyutil.handler.MessageParts;

public final class ChunkedFramingMechanismEncoder
extends FramingMechanismEncoder {
    public static final int DEFAULT_CHUNK_SIZE = 8192;
    public static final int MIN_CHUNK_SIZE = 128;
    public static final int MAX_CHUNK_SIZE = 0x1000000;
    private final int chunkSize;

    public ChunkedFramingMechanismEncoder() {
        this(8192);
    }

    public ChunkedFramingMechanismEncoder(int chunkSize) {
        if (chunkSize < 128) {
            throw new IllegalArgumentException(chunkSize + " is lower than minimum supported 128");
        }
        if (chunkSize > 0x1000000) {
            throw new IllegalArgumentException(chunkSize + " is lower than maximum supported 16777216");
        }
        this.chunkSize = chunkSize;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        do {
            int xfer = Math.min(this.chunkSize, msg.readableBytes());
            out.writeBytes(MessageParts.START_OF_CHUNK);
            out.writeBytes(String.valueOf(xfer).getBytes(StandardCharsets.US_ASCII));
            out.writeByte(10);
            out.writeBytes(msg, xfer);
        } while (msg.isReadable());
        out.writeBytes(MessageParts.END_OF_CHUNK);
    }
}

