/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.MessageToByteEncoder;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.messages.FramingMechanism;
import org.opendaylight.netconf.nettyutil.handler.ChunkedFramingMechanismEncoder;
import org.opendaylight.netconf.nettyutil.handler.EOMFramingMechanismEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class FramingMechanismEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(FramingMechanismEncoder.class);

    FramingMechanismEncoder() {
    }

    public static final @NonNull FramingMechanismEncoder of(FramingMechanism framingMechanism) {
        LOG.debug("{} framing mechanism was selected.", (Object)framingMechanism);
        return switch (framingMechanism) {
            default -> throw new IncompatibleClassChangeError();
            case FramingMechanism.CHUNK -> new ChunkedFramingMechanismEncoder();
            case FramingMechanism.EOM -> new EOMFramingMechanismEncoder();
        };
    }
}

