/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

final class MessageParts {
    static final byte[] END_OF_MESSAGE;
    static final byte[] START_OF_CHUNK;
    static final byte[] END_OF_CHUNK;

    private MessageParts() {
    }

    private static byte[] getBytes(CharsetEncoder encoder, String str) throws CharacterCodingException {
        ByteBuffer buf = encoder.encode(CharBuffer.wrap(str));
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        return bytes;
    }

    static {
        CharsetEncoder encoder = StandardCharsets.US_ASCII.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            END_OF_MESSAGE = MessageParts.getBytes(encoder, "]]>]]>");
            START_OF_CHUNK = MessageParts.getBytes(encoder, "\n#");
            END_OF_CHUNK = MessageParts.getBytes(encoder, "\n##\n");
        }
        catch (CharacterCodingException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

