/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.nettyutil.handler.NetconfMessageToXMLEncoder;

public final class NetconfHelloMessageToXMLEncoder
extends NetconfMessageToXMLEncoder {
    @Override
    @VisibleForTesting
    public void encode(ChannelHandlerContext ctx, NetconfMessage msg, ByteBuf out) throws IOException, TransformerException {
        Preconditions.checkState((boolean)(msg instanceof HelloMessage), (String)"Netconf message of type %s expected, was %s", HelloMessage.class, msg.getClass());
        Optional headerOptional = ((HelloMessage)msg).getAdditionalHeader();
        if (headerOptional.isPresent()) {
            out.writeBytes(((NetconfHelloMessageAdditionalHeader)headerOptional.orElseThrow()).toFormattedString().getBytes(StandardCharsets.UTF_8));
        }
        super.encode(ctx, msg, out);
    }
}

