/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.exi;

import com.google.common.base.Suppliers;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.grammars.Grammars;
import org.opendaylight.netconf.shaded.exificient.grammars.GrammarFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EXISchema {
    NONE("none"){

        @Override
        Grammars createGrammar() {
            return GrammarFactory.newInstance().createSchemaLessGrammars();
        }
    }
    ,
    BUILTIN("builtin"){

        @Override
        Grammars createGrammar() {
            try {
                return GrammarFactory.newInstance().createXSDTypesOnlyGrammars();
            }
            catch (EXIException e) {
                throw new IllegalStateException("Failed to create builtin grammar", e);
            }
        }
    }
    ,
    BASE_1_1("base:1.1"){

        @Override
        Grammars createGrammar() {
            Grammars grammars;
            block8: {
                ByteSource source = Resources.asByteSource((URL)EXISchema.class.getResource("/rfc6241.xsd"));
                InputStream is = source.openStream();
                try {
                    Grammars g = GrammarFactory.newInstance().createGrammars(is);
                    g.setSchemaId(this.getOption());
                    grammars = g;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | EXIException e) {
                        throw new IllegalStateException("Failed to create RFC6241 grammar", e);
                    }
                }
                is.close();
            }
            return grammars;
        }
    };

    private String option;
    private Supplier<Grammars> grammarsSupplier;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="https://github.com/spotbugs/spotbugs/issues/1867")
    private EXISchema(String option) {
        this.option = Objects.requireNonNull(option);
        this.grammarsSupplier = Suppliers.memoize(this::createGrammar);
    }

    final String getOption() {
        return this.option;
    }

    final Grammars getGrammar() {
        return this.grammarsSupplier.get();
    }

    abstract Grammars createGrammar();

    static @Nullable EXISchema forOption(String id) {
        for (EXISchema s : EXISchema.values()) {
            if (!id.equals(s.getOption())) continue;
            return s;
        }
        return null;
    }
}

