/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.notifications;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opendaylight.netconf.api.NetconfMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NetconfNotification
extends NetconfMessage {
    public static final String NOTIFICATION = "notification";
    public static final String NOTIFICATION_NAMESPACE = "urn:ietf:params:netconf:capability:notification:1.0";
    public static final String RFC3339_DATE_FORMAT_BLUEPRINT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final String RFC3339_DATE_FORMAT_WITH_MILLIS_BLUEPRINT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX";
    public static final String EVENT_TIME = "eventTime";
    public static final Date UNKNOWN_EVENT_TIME = new Date(0L);
    private final Date eventTime;

    public NetconfNotification(Document notificationContent) {
        this(notificationContent, new Date());
    }

    public NetconfNotification(Document notificationContent, Date eventTime) {
        super(NetconfNotification.wrapNotification(notificationContent, eventTime));
        this.eventTime = eventTime;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    private static Document wrapNotification(Document notificationContent, Date eventTime) {
        Preconditions.checkNotNull((Object)notificationContent);
        Preconditions.checkNotNull((Object)eventTime);
        Element baseNotification = notificationContent.getDocumentElement();
        Element entireNotification = notificationContent.createElementNS(NOTIFICATION_NAMESPACE, NOTIFICATION);
        entireNotification.appendChild(baseNotification);
        Element eventTimeElement = notificationContent.createElementNS(NOTIFICATION_NAMESPACE, EVENT_TIME);
        eventTimeElement.setTextContent(NetconfNotification.getSerializedEventTime(eventTime));
        entireNotification.appendChild(eventTimeElement);
        notificationContent.appendChild(entireNotification);
        return notificationContent;
    }

    private static String getSerializedEventTime(Date eventTime) {
        return new SimpleDateFormat(RFC3339_DATE_FORMAT_BLUEPRINT).format(eventTime);
    }
}

