package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;


public enum FaultId {
    FAULTEXTSUPPLYUNDERVOLT(0, "FAULT_EXT_SUPPLY_UNDERVOLT"),
    
    FAULTREOVERTEMP(1, "FAULT_RE_OVERTEMP"),
    
    FAULTDIGINOVERDRIVE(2, "FAULT_DIG_IN_OVERDRIVE"),
    
    FAULTRFOUTOVERDRIVE(3, "FAULT_RF_OUT_OVERDRIVE"),
    
    FAULTTXGAINFAIL(4, "FAULT_TX_GAIN_FAIL"),
    
    FAULTRXGAINFAIL(5, "FAULT_RX_GAIN_FAIL"),
    
    FAULTVSWROUTOFRANGE(6, "FAULT_VSWR_OUTOF_RANGE"),
    
    FAULTNONAISGTMAMALFCT(7, "FAULT_NON_AISG_TMA_MALFCT"),
    
    FAULTLINKFAIL(8, "FAULT_LINK_FAIL"),
    
    FAULTORIPORTFAIL(9, "FAULT_ORI_PORT_FAIL"),
    
    FAULTORISYNCFAIL(10, "FAULT_ORI_SYNC_FAIL"),
    
    FAULTAISGMALFCT(11, "FAULT_AISG_MALFCT")
    ;


    java.lang.String name;
    int value;
    private static final java.util.Map<java.lang.Integer, FaultId> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, FaultId> b = com.google.common.collect.ImmutableMap.builder();
        for (FaultId enumItem : FaultId.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private FaultId(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding FaultId item
     */
    public static FaultId forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
