package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime;
import java.util.List;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * grouping faultInd {
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf faultId {
 *         type FaultId;
 *     }
 *     leaf state {
 *         type FaultState;
 *     }
 *     leaf severity {
 *         type FaultSeverity;
 *     }
 *     leaf timestamp {
 *         type xsd-dateTime;
 *     }
 *     leaf descr {
 *         type string;
 *     }
 *     leaf-list affectedObj {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/faultInd</i>
 *
 */
public interface FaultInd
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "faultInd").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId</code> <code>objId</code>, or <code>null</code> if not present
     */
    ObjId getObjId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultId</code> <code>faultId</code>, or <code>null</code> if not present
     */
    FaultId getFaultId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultState</code> <code>state</code>, or <code>null</code> if not present
     */
    FaultState getState();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultSeverity</code> <code>severity</code>, or <code>null</code> if not present
     */
    FaultSeverity getSeverity();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime</code> <code>timestamp</code>, or <code>null</code> if not present
     */
    XsdDateTime getTimestamp();
    
    /**
     * @return <code>java.lang.String</code> <code>descr</code>, or <code>null</code> if not present
     */
    java.lang.String getDescr();
    
    /**
     * @return <code>java.util.List</code> <code>affectedObj</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getAffectedObj();

}

