package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.Obj;
import java.util.List;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * grouping getFaultOutput {
 *     list obj {
 *         key "id"
 *         leaf id {
 *             type ObjId;
 *         }
 *         list fault {
 *             key "id"
 *             leaf id {
 *                 type FaultId;
 *             }
 *             leaf severity {
 *                 type FaultSeverity;
 *             }
 *             leaf timestamp {
 *                 type xsd-dateTime;
 *             }
 *             leaf descr {
 *                 type string;
 *             }
 *             leaf-list affectedObj {
 *                 type string;
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/getFaultOutput</i>
 *
 */
public interface GetFaultOutput
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "getFaultOutput").intern();

    /**
     * @return <code>java.util.List</code> <code>obj</code>, or <code>null</code> if not present
     */
    List<Obj> getObj();

}

